/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.PageManager;
import org.apache.sling.cms.ResourceTree;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.reference.forms.impl.FormRequestImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=reference/components/forms/form", "sling.servlet.methods=POST", "sling.servlet.extensions=html", "sling.servlet.selectors=allowpost"})
public class FormHandler
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(FormHandler.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private List<FormAction> formActions;
    private static final long serialVersionUID = -8149443208959899098L;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String pagePath = Optional.ofNullable(request.getResource().adaptTo(PageManager.class)).map(PageManager::getPage).map(Page::getPath).orElse(StringUtils.substringBefore((String)request.getResource().getPath(), (String)"/jcr:content"));
        List actionResources = ResourceTree.stream((Resource)request.getResource().getChild("actions")).map(ResourceTree::getResource).collect(Collectors.toList());
        try {
            FormRequest formRequest = this.getFormRequest(request);
            if (formRequest == null) {
                log.warn("Unable to create form request");
                response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, pagePath) + ".html?error=fields");
                return;
            }
            request.getSession().setAttribute(formRequest.getSessionId(), (Object)formRequest.getFormData());
            block2: for (Resource actionResource : actionResources) {
                log.debug("Finding action handler for: {}", (Object)actionResource);
                for (FormAction action : this.formActions) {
                    if (!action.handles(actionResource)) continue;
                    log.debug("Invoking handler: {}", action.getClass());
                    action.handleForm(actionResource, formRequest);
                    continue block2;
                }
            }
            request.getSession().removeAttribute(formRequest.getSessionId());
        }
        catch (FormException e) {
            log.warn("Exception executing actions", (Throwable)e);
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, pagePath) + ".html?error=actions");
            return;
        }
        String thankYouPage = (String)request.getResource().getValueMap().get("successPage", String.class);
        if (StringUtils.isNotBlank((CharSequence)thankYouPage)) {
            if ("forward".equals(request.getResource().getValueMap().get("successAction", String.class))) {
                SlingHttpServletRequestWrapper requestWrapper = new SlingHttpServletRequestWrapper(request){

                    public String getMethod() {
                        return "GET";
                    }
                };
                request.getRequestDispatcher(thankYouPage).forward((ServletRequest)requestWrapper, (ServletResponse)response);
            } else {
                response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, thankYouPage) + ".html?message=success");
            }
        } else {
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, pagePath) + ".html?message=success");
        }
    }

    protected FormRequest getFormRequest(SlingHttpServletRequest request) throws FormException {
        FormRequest fr = (FormRequest)request.adaptTo(FormRequest.class);
        if (fr != null) {
            ((FormRequestImpl)fr).initFields();
            return fr;
        }
        throw new FormException("Unable to adapt to a form request");
    }
}

