/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ItemList {
    private static final Logger log = LoggerFactory.getLogger(List.class);
    private int count;
    private int end;
    @RequestAttribute
    private String limit;
    private int page;
    private Integer[] pages;
    @RequestAttribute
    private String query;
    private SlingHttpServletRequest request;
    private List<Resource> items = new ArrayList<Resource>();
    private int start;

    public ItemList(SlingHttpServletRequest request) {
        this.request = request;
    }

    public int getCount() {
        return this.count;
    }

    public int getCurrentPage() {
        return this.page + 1;
    }

    public int getEnd() {
        return this.end;
    }

    public Integer[] getPages() {
        return this.pages;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Resource> getItems() {
        return this.items;
    }

    public int getStart() {
        return this.start;
    }

    @PostConstruct
    public void init() {
        log.trace("init");
        HashSet<String> distinct = new HashSet<String>();
        if (this.request.getRequestPathInfo().getSuffix() != null) {
            this.query = this.query.replace("{SUFFIX}", this.request.getRequestPathInfo().getSuffix());
        }
        log.debug("Listing results of: {}", (Object)this.query);
        Iterator res = this.request.getResourceResolver().findResources(this.query, "JCR-SQL2");
        while (res.hasNext()) {
            Resource result = (Resource)res.next();
            if (distinct.contains(result.getPath())) continue;
            this.items.add(result);
            distinct.add(result.getPath());
        }
        this.count = this.items.size();
        log.debug("Found {} results", (Object)this.count);
        if (StringUtils.isNotBlank((CharSequence)this.request.getParameter("page")) && this.request.getParameter("page").matches("\\d+")) {
            this.page = Integer.parseInt(this.request.getParameter("page"), 10) - 1;
            log.debug("Using page {}", (Object)this.page);
        } else {
            this.page = 0;
            log.debug("Page {} not specified or not valid", (Object)this.request.getParameter("page"));
        }
        int l = Integer.parseInt(this.limit, 10);
        this.start = this.page * l >= this.count ? this.count : this.page * l;
        log.debug("Using start {}", (Object)this.start);
        this.end = this.page * l + l >= this.count ? this.count : this.page * l + l;
        log.debug("Using end {}", (Object)this.end);
        this.items = this.items.subList(this.start, this.end);
        ArrayList<Integer> pgs = new ArrayList<Integer>();
        int max = (int)Math.ceil((double)this.count / (double)l) + 1;
        for (int i = 1; i < max; ++i) {
            pgs.add(i);
        }
        this.pages = pgs.toArray(new Integer[pgs.size()]);
        if (log.isDebugEnabled()) {
            log.debug("Loaded pages {}", (Object)Arrays.toString((Object[])this.pages));
        }
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        if (this.pages.length > 0) {
            return this.page + 1 == this.pages[this.pages.length - 1];
        }
        return true;
    }
}

