/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.reference.SearchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SearchService.class})
@Designate(ocd=Config.class)
public class SearchServiceImpl
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    @Reference
    private ResourceResolverFactory factory;
    private Config config;

    @Activate
    public void init(Config config) {
        this.config = config;
    }

    @Override
    public ResourceResolver getResourceResolver(SlingHttpServletRequest request) {
        if (this.config != null && StringUtils.isNotBlank((String)this.config.searchServiceUsername())) {
            try {
                log.debug("Retrieving Service User {}", (Object)this.config.searchServiceUsername());
                return this.factory.getServiceResourceResolver((Map)new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("sling.service.subservice", SearchServiceImpl.this.config.searchServiceUsername());
                    }
                });
            }
            catch (LoginException e) {
                log.warn("Failed to retrieve Service User {}, falling back to request user", (Object)this.config.searchServiceUsername());
                return request.getResourceResolver();
            }
        }
        log.debug("Using request user");
        return request.getResourceResolver();
    }

    @Override
    public void closeResolver(ResourceResolver resolver) {
        if (resolver != null && resolver.isLive() && StringUtils.isNotBlank((String)this.config.searchServiceUsername()) && this.config.searchServiceUsername().equals(resolver.getUserID())) {
            resolver.close();
        }
    }

    @ObjectClassDefinition(name="%cms.reference.search.name", description="%cms.reference.search.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%searchServiceUsername.name", description="%searchServiceUsername.description")
        public String searchServiceUsername();
    }
}

