/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class StartContent {
    private static final Logger log = LoggerFactory.getLogger(StartContent.class);
    private ResourceResolver resolver;
    private String term;

    public StartContent(SlingHttpServletRequest request) {
        this.resolver = request.getResourceResolver();
        this.term = request.getParameter("q");
    }

    public List<Resource> getRelatedContent() {
        return this.get10Related(this.resolver, this.term).sorted((o1, o2) -> {
            try {
                return (int)((o1.getScore() - o2.getScore()) * 100.0);
            }
            catch (RepositoryException e) {
                log.warn("Exception getting score", (Throwable)e);
                return 0;
            }
        }).limit(9L).map(row -> {
            try {
                return this.resolver.getResource(row.getPath());
            }
            catch (RepositoryException e) {
                log.warn("Failed to get resource", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Resource> getRecentContent() {
        return this.get10Recent(this.resolver).sorted((o1, o2) -> ((Date)o1.getValueMap().get("jcr:content/jcr:lastModified", (Object)new Date())).compareTo((Date)o2.getValueMap().get("jcr:content/jcr:lastModified", (Object)new Date())) * -1).limit(10L).collect(Collectors.toList());
    }

    private Stream<Resource> get10Recent(ResourceResolver resolver) {
        Iterator it = resolver.findResources("SELECT * FROM [nt:hierarchyNode] WHERE [jcr:content/jcr:lastModifiedBy] = '" + resolver.getUserID() + "' AND ISDESCENDANTNODE([/content]) ORDER BY [jcr:content/jcr:lastModified] DESC", "JCR-SQL2");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 256), false).limit(10L);
    }

    private Stream<Row> get10Related(ResourceResolver resolver, String term) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            try {
                Query query = session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:hierarchyNode] AS s WHERE ISDESCENDANTNODE([/content]) AND CONTAINS(s.*,'" + term.replace("'", "''") + "')", "JCR-SQL2");
                query.setLimit(10L);
                QueryResult result = query.execute();
                Iterable iterable = () -> {
                    try {
                        return result.getRows();
                    }
                    catch (RepositoryException e) {
                        log.warn("Failed to get iterator", (Throwable)e);
                        return null;
                    }
                };
                return StreamSupport.stream(iterable.spliterator(), false).limit(10L);
            }
            catch (RepositoryException e) {
                log.warn("Exception searching for related content", (Throwable)e);
            }
        }
        return new ArrayList().stream();
    }
}

