/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.servlets;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=sling/servlet/errorhandler/default", "sling.servlet.prefix=-1", "service.ranking:Integer=1"})
public class CmsDefaultErrorHandlerServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CmsDefaultErrorHandlerServlet.class);
    public static final String DEFAULT_ERROR_PAGE = "default";
    public static final String SERVICE_USER_NAME = "sling-cms-error";
    public static final String SITE_ERRORS_SUBPATH = "errors/";
    public static final String SLING_CMS_ERROR_PATH = "/static/sling-cms/errorhandling/";
    private final transient ResourceResolverFactory factory;

    @Activate
    public CmsDefaultErrorHandlerServlet(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        if (req instanceof SlingHttpServletRequest) {
            this.handleError((SlingHttpServletRequest)req, (SlingHttpServletResponse)res);
        } else {
            log.error("Unable to handle request, not an instance of SlingHttpServletRequest: {}", (Object)req);
        }
    }

    private void handleError(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) {
        Resource resource = slingRequest.getResource();
        ResourceResolver resolver = slingRequest.getResourceResolver();
        int errorCode = this.getErrorCode(slingRequest, resolver);
        log.debug("Calculating error handling scripts for resource {} and error code {}", (Object)resource, (Object)errorCode);
        if (slingRequest.getAttribute("javax.servlet.error.exception") != null) {
            log.warn("Handing exception of type {} {}", (Object)errorCode, slingRequest.getAttribute("javax.servlet.error.exception"));
        }
        Resource handler = null;
        try {
            SiteManager siteMgr = (SiteManager)resource.adaptTo(SiteManager.class);
            if (siteMgr != null && siteMgr.getSite() != null) {
                Site site = siteMgr.getSite();
                log.debug("Checking for error pages in the site {}", (Object)site.getPath());
                handler = site.getResource().getChild(SITE_ERRORS_SUBPATH + errorCode);
                if (handler == null) {
                    handler = site.getResource().getChild("errors/default");
                }
                if (handler != null) {
                    log.debug("Using error handler {}", (Object)handler);
                } else {
                    log.debug("No error page defined for site {}", (Object)site.getPath());
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to retrieve current site, using default error handling");
        }
        if (handler == null) {
            log.debug("Using Sling CMS default error pages");
            handler = resolver.getResource(SLING_CMS_ERROR_PATH + errorCode);
            if (handler == null) {
                handler = resolver.getResource("/static/sling-cms/errorhandling/default");
            }
            log.debug("Using Sling CMS error handler {}", (Object)handler);
        }
        log.debug("Sending error {}", (Object)errorCode);
        slingResponse.reset();
        slingResponse.setContentType("text/html");
        slingResponse.setStatus(errorCode);
        this.doInclude(slingRequest, slingResponse, handler);
        log.debug("Error handler initialized successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getErrorCode(SlingHttpServletRequest slingRequest, ResourceResolver resolver) {
        int errorCode = Optional.ofNullable(slingRequest.getAttribute("javax.servlet.error.status_code")).map(val -> Integer.parseInt(val.toString())).orElse(500);
        if (errorCode == 404) {
            log.debug("Validating the resource does not exist for all users");
            try (ResourceResolver adminResolver = null;){
                adminResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER_NAME));
                Resource pResource = adminResolver.resolve((HttpServletRequest)slingRequest, slingRequest.getResource().getPath());
                errorCode = !CMSUtils.isPublished((Resource)pResource) || pResource.isResourceType("sling:nonexisting") ? 404 : ("anonymous".equals(resolver.getUserID()) ? 401 : 403);
            }
        }
        return errorCode;
    }

    private void doInclude(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, Resource handler) {
        Resource handlerContent = handler.getChild("jcr:content");
        if (handlerContent != null) {
            log.debug("Including handler {}", (Object)handlerContent);
            RequestDispatcherOptions rdo = new RequestDispatcherOptions();
            rdo.setReplaceSelectors("");
            rdo.setReplaceSuffix("");
            rdo.setForceResourceType(handlerContent.getResourceType());
            RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(handlerContent, rdo);
            if (dispatcher != null) {
                try {
                    dispatcher.include((ServletRequest)new GetRequest(slingRequest), (ServletResponse)slingResponse);
                }
                catch (Exception e) {
                    log.error("Exception swallowed while including error page", (Throwable)e);
                }
            } else {
                log.warn("Failed to get request dispatcher for handler {}", (Object)handler.getPath());
            }
        } else {
            log.warn("Error hander {} content is null", (Object)handler);
        }
    }

    private static class GetRequest
    extends SlingHttpServletRequestWrapper {
        public GetRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }

        public RequestPathInfo getRequestPathInfo() {
            return new HTMLRequestPathInfo(super.getRequestPathInfo());
        }
    }

    private static class HTMLRequestPathInfo
    implements RequestPathInfo {
        private RequestPathInfo info;

        public HTMLRequestPathInfo(RequestPathInfo info) {
            this.info = info;
        }

        public String getResourcePath() {
            return this.info.getResourcePath();
        }

        public String getExtension() {
            return "html";
        }

        public String getSelectorString() {
            return "";
        }

        public String[] getSelectors() {
            return new String[0];
        }

        public String getSuffix() {
            return "";
        }

        public Resource getSuffixResource() {
            return null;
        }
    }
}

