/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.cms.core.publication.ForwardAgentEndpointSynchronizationConfig;
import org.apache.sling.cms.publication.INSTANCE_TYPE;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TopologyEventListener.class}, immediate=true)
@Designate(ocd=ForwardAgentEndpointSynchronizationConfig.class)
public class ForwardAgentEndpointSynchronization
implements TopologyEventListener {
    private static final Logger log = LoggerFactory.getLogger(ForwardAgentEndpointSynchronization.class);
    private ForwardAgentEndpointSynchronizationConfig config;
    public static final String ENDPOINT_PROPERTY = "packageImporter.endpoints";
    private ConfigurationAdmin configAdmin;

    @Activate
    public ForwardAgentEndpointSynchronization(@Reference ConfigurationAdmin configAdmin, ForwardAgentEndpointSynchronizationConfig config) {
        this.configAdmin = configAdmin;
        this.config = config;
    }

    private void updateInstances(Set<InstanceDescription> instances) {
        log.info("updateInstances");
        Object[] endpoints = instances.stream().map(id -> {
            String endpointBase = id.getProperty("org.apache.sling.instance.endpoints").split("\\,")[0];
            return endpointBase + id.getProperty("pub.endpointPaths");
        }).collect(Collectors.toList()).toArray(new String[0]);
        if (log.isDebugEnabled()) {
            log.debug("Updating with endpoints: [{}]", (Object)Arrays.stream(endpoints).collect(Collectors.joining(",")));
        }
        try {
            log.debug("Updating configurations matching: {}", (Object)this.config.agentTarget());
            Configuration[] configurations = this.configAdmin.listConfigurations("(&(service.factoryPid=org.apache.sling.distribution.agent.impl.ForwardDistributionAgentFactory)" + this.config.agentTarget() + ")");
            if (configurations != null) {
                for (Configuration cfg : configurations) {
                    log.debug("Updating configuration {}", (Object)cfg.getPid());
                    Dictionary properties = cfg.getProperties();
                    if (!Arrays.equals(endpoints, (String[])properties.get(ENDPOINT_PROPERTY))) {
                        properties.put(ENDPOINT_PROPERTY, endpoints);
                        cfg.update(properties);
                        log.debug("Configurations updated!");
                        continue;
                    }
                    log.debug("Configurations match, not updating");
                }
            } else {
                log.warn("No applicable configurations found");
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            log.error("Failed to update configuration", e);
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        Set renderers = event.getNewView().findInstances(id -> INSTANCE_TYPE.RENDERER.toString().equals(id.getProperty("pub.instanceType")));
        this.updateInstances(renderers);
    }
}

