/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.ConfigurableJobExecutor;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.ResourceTree;
import org.apache.sling.cms.publication.IsPublishableResourceContainer;
import org.apache.sling.cms.publication.IsPublishableResourceType;
import org.apache.sling.cms.publication.PublicationException;
import org.apache.sling.cms.publication.PublicationManager;
import org.apache.sling.cms.publication.PublicationManagerFactory;
import org.apache.sling.cms.publication.PublicationType;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class, ConfigurableJobExecutor.class}, property={"job.topics=cmsjob/org/apache/sling/cms/publication/Bulk"})
public class BulkPublicationJob
extends ConfigurableJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(BulkPublicationJob.class);
    public static final String TOPIC = "cmsjob/org/apache/sling/cms/publication/Bulk";
    @Reference
    private PublicationManagerFactory publicationManagerFactory;
    @Reference
    private ResourceResolverFactory factory;

    public JobExecutionResult doProcess(Job job, JobExecutionContext context, ResourceResolver resolver) {
        String[] paths = (String[])job.getProperty("paths", String[].class);
        PublicationType type = PublicationType.valueOf((String)((String)job.getProperty("type", String.class)));
        boolean deep = (Boolean)job.getProperty("deep", (Object)false);
        PublicationManager publicationManager = this.publicationManagerFactory.getPublicationManager();
        context.initProgress(paths.length, (long)paths.length * 5000L);
        log.info("Starting bulk publication: paths={}, type={}, deep={}", new Object[]{paths, type, deep});
        for (String path : paths) {
            Stream<Object> toPublish = null;
            Resource resource = resolver.getResource(path);
            toPublish = deep ? ResourceTree.stream((Resource)resource, (Predicate)new IsPublishableResourceContainer(), (Predicate)new IsPublishableResourceType()).map(rt -> (PublishableResource)rt.getResource().adaptTo(PublishableResource.class)) : Collections.singletonList((PublishableResource)resource.adaptTo(PublishableResource.class)).stream();
            toPublish.forEach(pr -> {
                try {
                    if (type == PublicationType.ADD) {
                        publicationManager.publish(pr);
                    } else {
                        publicationManager.unpublish(pr);
                    }
                    context.log("{0} complete for {1}", new Object[]{type, pr.getPath()});
                }
                catch (PublicationException e) {
                    context.log("{0} failed for {1}", new Object[]{type, pr.getPath()});
                    log.warn("Failed to publish {}", pr, (Object)e);
                }
            });
            context.log("Publication complete for path: {0}", new Object[]{path});
            context.incrementProgressCount(1);
        }
        context.log("Publication complete!", new Object[0]);
        return context.result().succeeded();
    }

    public String getConfigurationPath() {
        return "/mnt/overlay/sling-cms/content/publication/bulk";
    }

    public ResourceResolverFactory getResolverFactory() {
        return this.factory;
    }

    public String getTitleKey() {
        return "slingcms.bulkpublication.title";
    }

    public String getTopic() {
        return TOPIC;
    }
}

