/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.cms.core.internal.filters.CMSSecurityFilterConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={CMSSecurityConfigInstance.class})
@Designate(ocd=CMSSecurityFilterConfig.class, factory=true)
public class CMSSecurityConfigInstance {
    private CMSSecurityFilterConfig config;
    private final List<Pattern> patterns = new ArrayList<Pattern>();

    @Modified
    @Activate
    public void activate(CMSSecurityFilterConfig config) {
        this.config = config;
        if (config.allowedPatterns() != null) {
            for (String p : config.allowedPatterns()) {
                this.patterns.add(Pattern.compile(p));
            }
        }
    }

    public boolean applies(HttpServletRequest request) {
        return ArrayUtils.isEmpty((Object[])this.config.hostDomains()) || ArrayUtils.contains((Object[])this.config.hostDomains(), (Object)request.getServerName());
    }

    public String getGroupName() {
        return this.config.group();
    }

    public boolean isUriAllowed(String uri) {
        for (Pattern p : this.patterns) {
            if (!p.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }
}

