/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.servlets;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=sling:Page", "sling.servlet.methods=TRACE", "sling.servlet.methods=GET", "sling.servlet.methods=OPTIONS", "sling.servlet.methods=HEAD"})
public class CMSPageServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -410942682163323725L;
    private static final Logger log = LoggerFactory.getLogger(CMSPageServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource contentResource = request.getResourceResolver().getResource(request.getResource(), "jcr:content");
        if (contentResource == null) {
            log.error("No countent for page {}", (Object)request.getResource());
            response.sendError(404, "no content");
            return;
        }
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(contentResource);
        if (requestDispatcher != null) {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.error("Failed to get request dispatcher for content of {}", (Object)request.getResource());
        throw new ServletException("No Content");
    }
}

