/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.models.SiteConfig;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Site {
    public static final String PN_CONFIG = "sling:configRef";
    public static final String PN_URL = "sling:url";
    @Inject
    @Named(value="sling:configRef")
    @Optional
    private String config;
    @Inject
    @Named(value="jcr:description")
    @Optional
    private String description;
    @Inject
    @Named(value="jcr:language")
    private String locale;
    private Resource resource;
    @Inject
    @Named(value="jcr:title")
    private String title;
    @Inject
    @Named(value="sling:url")
    private String url;

    private static Resource findSiteResource(Resource resource) {
        if ("sling:Site".equals(resource.getValueMap().get("jcr:primaryType", String.class))) {
            return resource;
        }
        if (resource.getParent() != null) {
            return Site.findSiteResource(resource.getParent());
        }
        return null;
    }

    public static Site getSite(Resource resource) {
        Site site = null;
        Resource siteResource = Site.findSiteResource(resource);
        if (siteResource != null) {
            site = (Site)siteResource.adaptTo(Site.class);
        }
        return site;
    }

    public Site(Resource resource) {
        this.resource = resource;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Site other = (Site)obj;
        return !(this.resource == null ? other.resource != null : !this.resource.getPath().equals(other.resource.getPath()));
    }

    public String getDescription() {
        return this.description;
    }

    public Locale getLocale() {
        String[] segments = this.locale.split("_");
        if (segments.length == 3) {
            return new Locale(segments[0], segments[1], segments[2]);
        }
        if (segments.length == 2) {
            return new Locale(segments[0], segments[1]);
        }
        return new Locale(segments[0]);
    }

    public String getLocaleString() {
        return this.locale;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public SiteConfig getSiteConfig() {
        Resource scr = this.resource.getResourceResolver().getResource(this.getSiteConfigPath());
        if (scr != null) {
            return (SiteConfig)scr.adaptTo(SiteConfig.class);
        }
        return null;
    }

    public String getSiteConfigPath() {
        return this.config;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource.getPath() == null ? 0 : this.resource.getPath().hashCode());
        return result;
    }

    public String toString() {
        return "Site [config=" + this.config + ", description=" + this.description + ", locale=" + this.locale + ", resource=" + this.resource + ", title=" + this.title + ", url=" + this.url + "]";
    }
}

