/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceOperation {
    private static final Logger log = LoggerFactory.getLogger(ReferenceOperation.class);
    private Pattern regex = null;
    private Resource resource = null;

    public ReferenceOperation(Resource resource) {
        String path = resource.getPath().replace("/", "\\/");
        this.regex = "sling:Page".equals(resource.getResourceType()) ? Pattern.compile("(^" + path + "($|\\/)|(\\'|\\\")" + path + "(\\.html|\\'|\\\"|\\/))") : Pattern.compile("(^" + path + "($|\\/)|(\\'|\\\")" + path + "(\\'|\\\"|\\/))");
        this.resource = resource;
    }

    public void init() {
        log.debug("Finding references to {}", (Object)this.resource.getPath());
        String query = "SELECT * FROM [nt:base] AS s WHERE CONTAINS(s.*, '" + this.resource.getPath() + "')";
        Iterator resources = this.resource.getResourceResolver().findResources(query, "JCR-SQL2");
        log.debug("Checking for references with: {}", (Object)query);
        while (resources.hasNext()) {
            Resource r = (Resource)resources.next();
            log.debug("Checking for references in resource {}", (Object)r);
            ValueMap properties = r.getValueMap();
            for (String k : properties.keySet()) {
                if (properties.get((Object)k) instanceof String) {
                    Matcher matcher = this.regex.matcher((CharSequence)properties.get(k, String.class));
                    if (!matcher.find()) continue;
                    log.trace("Found reference in property {}@{}", (Object)r.getPath(), (Object)k);
                    this.doProcess(r, k);
                    continue;
                }
                if (!(properties.get((Object)k) instanceof String[])) continue;
                boolean matches = false;
                for (String v : (String[])properties.get(k, String[].class)) {
                    Matcher matcher = this.regex.matcher(v);
                    if (!matcher.find()) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                log.trace("Found reference in property {}@{}", (Object)r.getPath(), (Object)k);
                this.doProcess(r, k);
            }
        }
    }

    public abstract void doProcess(Resource var1, String var2);

    public Pattern getRegex() {
        return this.regex;
    }
}

