/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={SlingHttpServletRequest.class})
public class RedirectAttribute {
    private static final String LEVEL_SESSION_KEY = "REDIRECT_LEVEL";
    private static final String MESSAGE_SESSION_KEY = "REDIRECT_MESSAGE";
    private SlingHttpServletRequest request;

    public static void setMessage(HttpServletRequest request, LEVEL level, String message) {
        RedirectAttribute.setMessage(request.getSession(), level, message);
    }

    public static void setMessage(HttpSession session, LEVEL level, String message) {
        session.setAttribute(MESSAGE_SESSION_KEY, (Object)message);
        session.setAttribute(LEVEL_SESSION_KEY, (Object)level.toString());
    }

    public RedirectAttribute(SlingHttpServletRequest request) {
        this.request = request;
    }

    public String getLevel() {
        String level = (String)this.request.getSession().getAttribute(LEVEL_SESSION_KEY);
        if (level == null) {
            level = LEVEL.info.toString();
        }
        this.request.getSession().removeAttribute(LEVEL_SESSION_KEY);
        return level;
    }

    public String getMessageText() {
        String message = (String)this.request.getSession().getAttribute(MESSAGE_SESSION_KEY);
        this.request.getSession().removeAttribute(MESSAGE_SESSION_KEY);
        return message;
    }

    public boolean isMessageSet() {
        return this.request.getSession().getAttribute(MESSAGE_SESSION_KEY) != null;
    }

    public static enum LEVEL {
        danger,
        info,
        success,
        warning;

    }
}

