/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.models.PageTemplate;
import org.apache.sling.cms.core.models.Site;
import org.apache.sling.cms.core.models.SiteConfig;
import org.apache.sling.cms.core.models.SiteManager;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class})
public class PageTemplateManager {
    private SiteConfig siteConfig;
    private Resource resource;

    public PageTemplateManager(Resource resource) {
        Site site = ((SiteManager)resource.adaptTo(SiteManager.class)).getSite();
        this.siteConfig = site.getSiteConfig();
        this.resource = resource;
    }

    public List<PageTemplate> getAvailableTemplates() {
        String path = this.resource.getPath();
        ArrayList<PageTemplate> availableTemplates = new ArrayList<PageTemplate>();
        if (this.siteConfig != null && this.siteConfig.getPageTemplates() != null) {
            block0: for (PageTemplate template : this.siteConfig.getPageTemplates()) {
                if (template == null || template.getAllowedPaths() == null) continue;
                for (String allowedPath : template.getAllowedPaths()) {
                    if (!path.matches(allowedPath)) continue;
                    availableTemplates.add(template);
                    continue block0;
                }
            }
        }
        return availableTemplates;
    }

    public String toString() {
        return "PageTemplateManager [siteConfig=" + this.siteConfig + ", resource=" + this.resource + "]";
    }
}

