/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.core.models.AbstractContentModel;
import org.apache.sling.cms.core.models.PageTemplate;
import org.apache.sling.cms.core.models.Site;
import org.apache.sling.cms.core.models.SiteManager;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Page
extends AbstractContentModel {
    @Inject
    @Named(value="jcr:content/published")
    @Default(booleanValues={false})
    private boolean published;
    @Inject
    @Optional
    @Named(value="jcr:content/sling:taxonomy")
    private String[] taxonomy;
    @Inject
    @Optional
    @Named(value="jcr:content/sling:template")
    private String template;

    public static final Page getContainingPage(Resource resource) {
        Resource pageRsrc = CMSUtils.findParentResourceofType(resource, "sling:Page");
        Page page = null;
        if (pageRsrc != null) {
            page = (Page)pageRsrc.adaptTo(Page.class);
        }
        return page;
    }

    public Page(Resource resource) {
        this.resource = resource;
    }

    public String[] getKeywords() {
        ArrayList<Object> keywords = new ArrayList<Object>();
        if (this.taxonomy != null) {
            for (String item : this.taxonomy) {
                Resource resource = this.resource.getResourceResolver().getResource(item);
                if (resource == null) continue;
                keywords.add(resource.getValueMap().get("jcr:title", String.class));
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    public String getPublishedPath() {
        Site site = ((SiteManager)this.resource.adaptTo(SiteManager.class)).getSite();
        if (site != null) {
            return this.resource.getPath().replace(site.getPath(), "") + ".html";
        }
        return this.resource.getPath() + ".html";
    }

    public String getPublishedUrl() {
        Site site = ((SiteManager)this.resource.adaptTo(SiteManager.class)).getSite();
        if (site != null) {
            return site.getUrl() + this.getPublishedPath();
        }
        return this.resource.getPath();
    }

    public PageTemplate getTemplate() {
        Resource templateResource = this.resource.getResourceResolver().getResource(this.template);
        if (templateResource != null) {
            return (PageTemplate)templateResource.adaptTo(PageTemplate.class);
        }
        return null;
    }

    public String getTemplatePath() {
        return this.template;
    }
}

