/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.core.models.Site;
import org.apache.sling.cms.core.models.SiteManager;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);
    @RequestAttribute
    @Named(value="javax.servlet.error.status_code")
    @Optional
    @Default(intValues={500})
    private Integer errorCode;
    private SlingHttpServletRequest slingRequest;
    private Resource handler;
    @SlingObject
    private HttpServletResponse response;

    public ErrorHandler(SlingHttpServletRequest slingRequest) {
        this.slingRequest = slingRequest;
    }

    @PostConstruct
    public void init() throws IOException {
        Resource resource = this.slingRequest.getResource();
        ResourceResolver resolver = this.slingRequest.getResourceResolver();
        log.debug("Calculating error handling scripts for resource {} and error code {}", (Object)resource, (Object)this.errorCode);
        if (this.slingRequest.getAttribute("javax.servlet.error.exception") != null) {
            log.warn("Handing exception of type " + this.errorCode, this.slingRequest.getAttribute("javax.servlet.error.exception"));
        }
        try {
            SiteManager siteMgr = (SiteManager)resource.adaptTo(SiteManager.class);
            if (siteMgr != null && siteMgr.getSite() != null) {
                Site site = siteMgr.getSite();
                log.debug("Checking for error pages in the site {}", (Object)site.getPath());
                this.handler = site.getResource().getChild("errors/" + this.errorCode.toString());
                if (this.handler == null) {
                    this.handler = site.getResource().getChild("errors/default");
                }
                if (this.handler != null) {
                    log.debug("Using error handler {}", (Object)this.handler);
                } else {
                    log.debug("No error page defined for site {}", (Object)site.getPath());
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to retrieve current site, using default error handling");
        }
        if (this.handler == null) {
            log.debug("Using Sling CMS default error pages");
            this.handler = resolver.getResource("/content/sling-cms/errorhandling/" + this.errorCode.toString());
            if (this.handler == null) {
                this.handler = resolver.getResource("/content/sling-cms/errorhandling/default");
            }
            log.debug("Using Sling CMS error handler {}", (Object)this.handler);
        }
        log.debug("Sending error {}", (Object)this.errorCode);
        this.response.setStatus(this.errorCode.intValue());
        log.debug("Error handler initialized successfully!");
    }

    public Resource getHandler() {
        return this.handler;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

