/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Component {
    @Inject
    @Optional
    @Named(value="componentType")
    private String[] componentType;
    private Resource resource;
    @Inject
    @Optional
    @Named(value="jcr:title")
    private String title;

    public Component(Resource resource) {
        this.resource = resource;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        return !(this.resource == null ? other.resource != null : !this.resource.getPath().equals(other.resource.getPath()));
    }

    private Resource getComponentEditPath(Resource component) {
        if (component != null) {
            if (component.getChild("edit") != null) {
                return component.getChild("edit");
            }
            if ((component = component.getResourceResolver().getResource(component.getResourceResolver().getParentResourceType(component))) != null) {
                return this.getComponentEditPath(component);
            }
        }
        return null;
    }

    public String[] getComponentType() {
        return this.componentType;
    }

    public String getEditPath() {
        Resource editResource = this.getEditResource();
        return editResource != null ? editResource.getPath() : null;
    }

    public Resource getEditResource() {
        return this.getComponentEditPath(this.resource);
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource.getPath() == null ? 0 : this.resource.getPath().hashCode());
        return result;
    }

    public boolean isType(String type) {
        boolean isType = false;
        if (this.getComponentType() != null && ArrayUtils.contains((Object[])this.getComponentType(), (Object)type)) {
            isType = true;
            for (String t : this.getComponentType()) {
                if (!StringUtils.isNotBlank((String)t) || type.equals(t)) continue;
                isType = false;
            }
        }
        return isType;
    }

    public String toString() {
        return "Component [title=" + this.title + ", resource=" + this.resource + ", componentType=" + this.componentType + "]";
    }
}

