/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Optional;

public abstract class AbstractContentModel {
    @Inject
    @Optional
    @Named(value="jcr:content")
    private Resource contentResource;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:created")
    private Calendar created;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:createdBy")
    private String createdBy;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModified")
    private Calendar lastModified;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModifiedBy")
    private String lastModifiedBy;
    protected Resource resource;
    @Inject
    @Named(value="jcr:content/jcr:title")
    @Optional
    private String title;
    @Inject
    @Named(value="jcr:primaryType")
    private String type;

    public Resource getContentResource() {
        return this.contentResource;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Calendar getLastModified() {
        return this.lastModified != null ? this.lastModified : this.created;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy != null ? this.lastModifiedBy : this.createdBy;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Resource getParent() {
        return this.resource.getParent();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ValueMap getProperties() {
        return this.getContentResource().getValueMap();
    }

    public abstract boolean isPublished();

    public Resource getResource() {
        return this.resource;
    }

    public String getTitle() {
        if (StringUtils.isNotEmpty((String)this.title)) {
            return this.title;
        }
        return this.resource.getName();
    }

    public String getType() {
        return this.type;
    }
}

