/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;

@Component(service={Filter.class}, property={"sling.filter.scope=request", "service.ranking=2147483647"})
public class PublishFilter
implements Filter {
    public static final String[] PUBLISHABLE_TYPES = new String[]{"sling:File", "sling:Page", "sling:Folder", "sling:OrderedFolder"};
    public static final String[] VALID_METHODS = new String[]{"GET", "HEAD"};

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Resource publishable;
        Object editEnabled;
        SlingHttpServletRequest slingRequest;
        if (request instanceof SlingHttpServletRequest && ArrayUtils.contains((Object[])VALID_METHODS, (Object)(slingRequest = (SlingHttpServletRequest)request).getMethod()) && !"true".equals(editEnabled = slingRequest.getAttribute("cmsEditEnabled")) && (publishable = this.findPublishableParent(slingRequest.getResource())) != null && publishable.getChild("jcr:content") != null && !((Boolean)publishable.getChild("jcr:content").getValueMap().get("published", (Object)true)).booleanValue()) {
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        chain.doFilter(request, response);
    }

    private Resource findPublishableParent(Resource resource) {
        String type = (String)resource.getValueMap().get("jcr:primaryType", String.class);
        if (ArrayUtils.contains((Object[])PUBLISHABLE_TYPES, (Object)type)) {
            return resource;
        }
        if (resource.getParent() != null) {
            return this.findPublishableParent(resource.getParent());
        }
        return null;
    }

    public void destroy() {
    }
}

