/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.filters;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.core.models.Site;
import org.apache.sling.cms.core.models.SiteManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, immediate=true, property={"sling.filter.scope=request"})
public class LocaleFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LocaleFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            Site site = ((SiteManager)slingRequest.getResource().adaptTo(SiteManager.class)).getSite();
            if (site != null) {
                log.debug("Setting bundle for {}", (Object)site.getLocaleString());
                ResourceBundle bundle = slingRequest.getResourceBundle(site.getLocale());
                Config.set((ServletRequest)slingRequest, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(bundle, slingRequest.getLocale()));
            } else {
                log.trace("No site for {}", (Object)slingRequest);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

