/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.internal.ResourceEditorAssociation;
import org.apache.sling.cms.core.internal.ResourceEditorAssociationProvider;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class ContentBreadcrumb {
    private static final Logger log = LoggerFactory.getLogger(ContentBreadcrumb.class);
    private long depth;
    private List<Pair<String, String>> parents;
    @OSGiService
    private ResourceEditorAssociationProvider provider;
    private Resource resource;
    private String rootTitle;

    public ContentBreadcrumb(SlingHttpServletRequest request) {
        this.resource = request.getRequestPathInfo().getSuffixResource();
        log.debug("Loading configuration from {}", (Object)request.getResource().getValueMap());
        this.depth = (Long)request.getResource().getValueMap().get("depth", (Object)0L);
        this.rootTitle = (String)request.getResource().getValueMap().get("rootTitle", String.class);
    }

    public String getCurrentItem() {
        if ((this.parents == null || this.parents.isEmpty()) && StringUtils.isNotBlank((CharSequence)this.rootTitle)) {
            return this.rootTitle;
        }
        return this.getTitle(this.resource);
    }

    private String getLink(Resource resource) {
        log.debug("Getting link for {} from {}", (Object)resource, this.provider.getAssociations());
        return this.provider.getAssociations().stream().filter(a -> a.matches(resource)).findFirst().map(ResourceEditorAssociation::getEditor).orElse("/bin/browser.html") + resource.getPath();
    }

    public List<Pair<String, String>> getParents() {
        return this.parents;
    }

    private String getTitle(Resource resource) {
        String title = (String)resource.getValueMap().get("jcr:title", String.class);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        title = (String)resource.getValueMap().get("jcr:content/jcr:title", String.class);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        return resource.getName();
    }

    @PostConstruct
    public void init() {
        Resource parent;
        List<Object> ps = new ArrayList<Resource>();
        Resource current = this.resource;
        while ((parent = current.getParent()) != null) {
            ps.add(parent);
            current = parent;
        }
        Collections.reverse(ps);
        if (this.depth <= (long)ps.size()) {
            ps = ps.subList((int)this.depth, ps.size());
        } else {
            ps.clear();
        }
        this.parents = ps.stream().map(p -> new ImmutablePair((Object)this.getLink((Resource)p), (Object)this.getTitle((Resource)p))).collect(Collectors.toList());
        if (!this.parents.isEmpty() && StringUtils.isNotBlank((CharSequence)this.rootTitle)) {
            this.parents.set(0, (Pair<String, String>)new ImmutablePair(this.parents.get(0).getLeft(), (Object)this.rootTitle));
        }
    }
}

