/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaintenanceJob
implements Runnable,
JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractMaintenanceJob.class);
    protected JobManager jobManager;

    protected final JobExecutionResult createResult(JobExecutionContext context, Optional<CompositeData> data, Integer startId) {
        String message = data.map(d -> (String)d.get("message")).orElse(null);
        RepositoryManagementMBean.StatusCode code = data.map(d -> (Integer)d.get("code")).map(c -> Arrays.stream(RepositoryManagementMBean.StatusCode.values()).filter(sc -> sc.ordinal() == c.intValue()).findFirst().orElse(RepositoryManagementMBean.StatusCode.NONE)).orElse(RepositoryManagementMBean.StatusCode.NONE);
        log.trace("Loaded status code: {}", (Object)code);
        Integer id = data.map(d -> (Integer)d.get("id")).orElse(null);
        boolean success = false;
        StringBuilder sb = new StringBuilder(this.getPrefix());
        if (!data.isPresent() || code == null) {
            log.trace("No result...");
            sb.append("No result.");
        } else if (startId != null && (id == null || id.intValue() != startId.intValue())) {
            log.trace("ID does not match original ID, assuming successful...");
            sb.append(RepositoryManagementMBean.StatusCode.SUCCEEDED.name);
            success = true;
        } else if (code == RepositoryManagementMBean.StatusCode.INITIATED || code == RepositoryManagementMBean.StatusCode.SUCCEEDED) {
            log.trace("Successful result: {}...", (Object)code.name);
            sb.append(code.name);
            success = true;
        } else if (code == RepositoryManagementMBean.StatusCode.UNAVAILABLE || code == RepositoryManagementMBean.StatusCode.NONE || code == RepositoryManagementMBean.StatusCode.FAILED) {
            log.trace("Failed result: {}...", (Object)code.name);
            sb.append(code.name);
        } else {
            return null;
        }
        if (message != null) {
            sb.append(" ");
            sb.append(message);
        }
        JobExecutionContext.ResultBuilder rb = context.result().message(sb.toString());
        return success ? rb.succeeded() : rb.failed();
    }

    public abstract String getJobTopic();

    public abstract String getPrefix();

    public abstract Optional<CompositeData> getStatus();

    public JobExecutionResult process(Job job, JobExecutionContext context) {
        log.info("Starting {}", (Object)this.getPrefix());
        Optional<CompositeData> data = this.startMaintenance();
        Integer id = data.map(d -> (Integer)d.get("id")).orElse(null);
        JobExecutionResult result = null;
        while (result == null) {
            data = this.getStatus();
            result = this.createResult(context, data, id);
            if (result == null) {
                if (context.isStopped()) {
                    log.info("Canceling {}. The task was either stopped by the user or the Maintenance Window reached its end", (Object)this.getPrefix());
                    this.stopMaintenance();
                    return context.result().message(String.format("%sStopped by user.", this.getPrefix())).failed();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            log.debug("Retrieved result: {}", (Object)result);
        }
        return result;
    }

    @Override
    public void run() {
        log.trace("Kicking off job: {}", (Object)this.getJobTopic());
        this.jobManager.addJob(this.getJobTopic(), Collections.emptyMap());
    }

    public abstract void setJobManager(JobManager var1);

    public abstract Optional<CompositeData> startMaintenance();

    public abstract Optional<CompositeData> stopMaintenance();
}

