/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.jsoup.helper.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=updatestatus"})
public class UpdateStatusOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(UpdateStatusOperation.class);
    public static final String PN_REASON = ":reason";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList changes = new ArrayList();
        try {
            String reason = request.getParameter(PN_REASON);
            AuthorizableWrapper authWrapper = (AuthorizableWrapper)Optional.ofNullable(request.getResource().adaptTo(AuthorizableWrapper.class)).orElseThrow(() -> new RepositoryException("Failed to get authorizable: " + request.getResource()));
            if (authWrapper.getAuthorizable().isGroup()) {
                throw new RepositoryException("Authorizable is not a user");
            }
            User user = (User)authWrapper.getAuthorizable();
            user.disable(StringUtil.isBlank((String)reason) ? null : reason);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.setPath(user.getPath());
            response.onCreated(user.getPath());
        }
        catch (Exception e) {
            log.warn("Failed to update user status", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

