/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Calendar;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.cms.File;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class}, adapters={File.class})
public class FileImpl
implements File {
    @Inject
    @Optional
    @Named(value="jcr:content")
    private Resource contentResource;
    @Inject
    @Named(value="jcr:content/jcr:mimeType")
    private String contentType;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:created")
    private Calendar created;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:createdBy")
    private String createdBy;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModified")
    private Calendar lastModified;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModifiedBy")
    private String lastModifiedBy;
    @Inject
    @Named(value="jcr:content/published")
    @Default(booleanValues={false})
    private boolean published;
    protected Resource resource;
    @Inject
    @Named(value="jcr:primaryType")
    private String type;

    public FileImpl(Resource resource) {
        this.resource = resource;
    }

    public Resource getContentResource() {
        return this.contentResource;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Calendar getLastModified() {
        return this.lastModified != null ? this.lastModified : this.created;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy != null ? this.lastModifiedBy : this.createdBy;
    }

    public ValueMap getMetadata() {
        Resource metadata = this.getContentResource().getChild("metadata");
        TreeMap data = new TreeMap();
        if (metadata != null) {
            metadata.getValueMap().entrySet().forEach(e -> data.put(Text.unescapeIllegalJcrChars((String)((String)e.getKey())), e.getValue()));
        }
        data.remove("jcr:primaryType");
        return new ValueMapDecorator(data);
    }

    public String getName() {
        return this.resource.getName();
    }

    public Resource getParent() {
        return this.resource.getParent();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ValueMap getProperties() {
        return this.getContentResource().getValueMap();
    }

    public String getPublishedPath() {
        Site site = this.getSite();
        if (site != null) {
            return this.resource.getPath().replace(site.getPath(), "");
        }
        return this.resource.getPath();
    }

    public String getPublishedUrl() {
        Site site = this.getSite();
        if (site != null) {
            return site.getUrl() + this.getPublishedPath();
        }
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Site getSite() {
        SiteManager siteMgr = (SiteManager)this.resource.adaptTo(SiteManager.class);
        Site site = null;
        if (siteMgr != null) {
            site = siteMgr.getSite();
        }
        return site;
    }

    public boolean isPublished() {
        return this.published;
    }
}

