/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.Component;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class}, adapters={Component.class})
public class ComponentImpl
implements Component {
    @Inject
    @Optional
    @Named(value="componentType")
    private String[] componentType;
    @Inject
    @Optional
    @Default(booleanValues={false})
    private boolean container;
    @Inject
    @Optional
    @Default(booleanValues={true})
    private boolean editable;
    @Inject
    @Optional
    @Default(booleanValues={false})
    private boolean reloadPage;
    private Resource resource;
    @Inject
    @Optional
    @Named(value="jcr:title")
    private String title;

    public ComponentImpl(Resource resource) {
        this.resource = resource;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        return !(this.resource == null ? other.getResource() != null : !this.resource.getPath().equals(other.getResource().getPath()));
    }

    private Resource getComponentEditPath(Resource component) {
        if (component != null) {
            if (component.getChild("edit") != null) {
                return component.getChild("edit");
            }
            String parentResourceType = component.getResourceResolver().getParentResourceType(component);
            if (StringUtils.isNotBlank((CharSequence)parentResourceType) && (component = component.getResourceResolver().getResource(parentResourceType)) != null) {
                return this.getComponentEditPath(component);
            }
        }
        return null;
    }

    public String[] getComponentType() {
        return this.componentType;
    }

    public String getEditPath() {
        Resource editResource = this.getEditResource();
        return editResource != null ? editResource.getPath() : null;
    }

    public Resource getEditResource() {
        return this.getComponentEditPath(this.resource);
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resource.getPath().hashCode();
        return result;
    }

    public boolean isContainer() {
        return this.container;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isReloadPage() {
        return this.reloadPage;
    }

    public boolean isType(String type) {
        boolean isType = false;
        if (this.getComponentType() != null && ArrayUtils.contains((Object[])this.getComponentType(), (Object)type)) {
            isType = true;
            for (String t : this.getComponentType()) {
                if (!StringUtils.isNotBlank((CharSequence)t) || type.equals(t)) continue;
                isType = false;
            }
        }
        return isType;
    }

    public String toString() {
        return "ComponentImpl [componentType=" + Arrays.toString(this.componentType) + ", editable=" + this.editable + ", container=" + this.container + ", reloadPage=" + this.reloadPage + ", resource=" + this.resource + ", title=" + this.title + "]";
    }
}

