/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, immediate=true, property={"sling.filter.scope=request"})
public class LocaleFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LocaleFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            Locale locale = null;
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            SiteManager mgr = (SiteManager)slingRequest.getResource().adaptTo(SiteManager.class);
            if (mgr != null) {
                Site site = mgr.getSite();
                if (site != null) {
                    log.debug("Setting bundle for {}", (Object)site.getLocaleString());
                    locale = site.getLocale();
                } else {
                    log.trace("No site for {}", (Object)slingRequest);
                }
            } else {
                log.trace("No site manager found for {}", (Object)slingRequest);
            }
            if (locale == null) {
                locale = this.loadUserLocale(locale, slingRequest);
            }
            if (locale == null) {
                locale = Locale.getDefault(Locale.Category.DISPLAY);
            }
            this.setLocale(locale, slingRequest);
        }
        chain.doFilter(request, response);
    }

    private Locale loadUserLocale(Locale locale, SlingHttpServletRequest slingRequest) {
        try {
            User user;
            Value[] value;
            UserManager userManager;
            JackrabbitSession session = (JackrabbitSession)slingRequest.getResourceResolver().adaptTo(Session.class);
            if (session != null && (userManager = session.getUserManager()).getAuthorizable(slingRequest.getResourceResolver().getUserID()) != null && (value = (user = (User)userManager.getAuthorizable(slingRequest.getResourceResolver().getUserID())).getProperty("profile/locale")) != null && value.length > 0) {
                locale = Locale.forLanguageTag(value[0].getString());
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to load locale from current user", (Throwable)e);
        }
        return locale;
    }

    private void setLocale(Locale locale, SlingHttpServletRequest slingRequest) {
        ResourceBundle bundle = slingRequest.getResourceBundle(locale);
        Config.set((ServletRequest)slingRequest, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(bundle, slingRequest.getLocale()));
    }

    public void destroy() {
    }
}

