/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import java.util.Optional;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    private CommonUtils() {
    }

    public static final UserManager getUserManager(ResourceResolver resolver) throws RepositoryException {
        return Optional.ofNullable(resolver.adaptTo(Session.class)).map(session -> {
            UserManager userManager = null;
            if (session instanceof JackrabbitSession) {
                try {
                    userManager = ((JackrabbitSession)session).getUserManager();
                }
                catch (RepositoryException e) {
                    log.error("Failed to get user manager", (Throwable)e);
                }
            }
            return userManager;
        }).orElseThrow(() -> new RepositoryException("Failed to get user manager"));
    }
}

