/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.repository;

import java.util.Optional;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.sling.cms.core.internal.repository.AbstractMaintenanceJob;
import org.apache.sling.cms.core.internal.repository.DataStoreCleanupConfig;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={JobExecutor.class, Runnable.class}, property={"job.topics=org/apache/sling/cms/repository/DataStoreCleanup"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=DataStoreCleanupConfig.class)
public class DataStoreCleanupScheduler
extends AbstractMaintenanceJob {
    private RepositoryManagementMBean repositoryManager;

    @Override
    public String getJobTopic() {
        return "org/apache/sling/cms/repository/DataStoreCleanup";
    }

    @Override
    public String getPrefix() {
        return "DataStore Cleanup";
    }

    @Override
    public Optional<CompositeData> getStatus() {
        return Optional.ofNullable(this.repositoryManager.getDataStoreGCStatus());
    }

    @Override
    @Reference
    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @Reference
    public void setRepositoryManager(RepositoryManagementMBean repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public Optional<CompositeData> startMaintenance() {
        return Optional.ofNullable(this.repositoryManager.startDataStoreGC(false));
    }

    @Override
    public Optional<CompositeData> stopMaintenance() {
        return Optional.ofNullable(this.repositoryManager.getDataStoreGCStatus());
    }
}

