/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.jobs;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.cms.CMSJobManager;
import org.apache.sling.cms.i18n.I18NDictionary;
import org.apache.sling.cms.i18n.I18NProvider;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/bin/cms/removejob", "sling.servlet.methods=POST"})
public class RemoveJobServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -8206750437666627792L;
    @Reference
    private transient I18NProvider provider;
    @Reference
    private transient JobManager jobManager;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        I18NDictionary dictionary = this.provider.getDictionary(request);
        String message = null;
        CMSJobManager jobMgr = (CMSJobManager)request.adaptTo(CMSJobManager.class);
        String id = request.getParameter("id");
        if (jobMgr != null && id != null) {
            jobMgr.deleteJob(id);
            message = dictionary.get("slingcms.jobs.jobremoved");
        } else {
            message = dictionary.get("slingcms.jobs.badrequest");
            response.sendError(400, message);
        }
        response.setContentType("application/json");
        response.getWriter().write("{\"title\":\"" + message + "\"}");
    }
}

