/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.core.internal.filters.CMSSecurityFilterConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"sling.filter.scope=request"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=CMSSecurityFilterConfig.class)
public class CMSSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CMSSecurityFilter.class);
    private CMSSecurityFilterConfig config;
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private static final String[] VALID_METHODS = new String[]{"GET", "HEAD"};

    @Modified
    @Activate
    public void activate(CMSSecurityFilterConfig config) {
        if (config.hostDomains() != null && config.hostDomains().length > 0) {
            if (log.isInfoEnabled()) {
                log.info("Applying CMS Security Filter for domains {}", (Object)Arrays.toString(config.hostDomains()));
            }
            this.config = config;
            for (String p : config.allowedPatterns()) {
                this.patterns.add(Pattern.compile(p));
            }
        } else {
            this.config = null;
            log.info("No host domains supplied, CMS Security Filter not enabled");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object editEnabled;
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        if (this.config != null && ArrayUtils.contains((Object[])this.config.hostDomains(), (Object)request.getServerName())) {
            log.trace("Filtering requests to host {}", (Object)request.getServerName());
            String uri = slingRequest.getRequestURI();
            boolean allowed = false;
            for (Pattern p : this.patterns) {
                if (!p.matcher(uri).matches()) continue;
                log.trace("Allowing request matching pattern {}", (Object)p);
                allowed = true;
                break;
            }
            if (!allowed) {
                if (StringUtils.isNotBlank((CharSequence)this.config.group())) {
                    allowed = this.checkGroupMembership(slingRequest);
                } else if (!"anonymous".equals(slingRequest.getResourceResolver().getUserID())) {
                    allowed = true;
                }
            }
            if (!allowed) {
                log.trace("Request to {} not allowed for user {}", (Object)slingRequest.getRequestURI(), (Object)slingRequest.getResourceResolver().getUserID());
                ((HttpServletResponse)response).sendError(401);
                return;
            }
        } else if (ArrayUtils.contains((Object[])VALID_METHODS, (Object)slingRequest.getMethod()) && !"true".equals(editEnabled = slingRequest.getAttribute("cmsEditEnabled")) && !CMSUtils.isPublished((Resource)slingRequest.getResource())) {
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean checkGroupMembership(SlingHttpServletRequest slingRequest) {
        boolean allowed = false;
        try {
            Session session = (Session)slingRequest.getResourceResolver().adaptTo(Session.class);
            UserManager userManager = null;
            if (session instanceof JackrabbitSession) {
                userManager = ((JackrabbitSession)session).getUserManager();
            }
            if (userManager == null) {
                log.warn("Unable to retrieve user manager");
                return false;
            }
            log.trace("Retrieved user manager {} with session {}", (Object)userManager, (Object)session);
            Authorizable auth = userManager.getAuthorizable(slingRequest.getUserPrincipal());
            if (auth == null) {
                log.warn("Unable to retrieve user from principal {}", (Object)slingRequest.getUserPrincipal());
                return false;
            }
            log.trace("Checking to see if user {} is in required group {}", (Object)auth.getID(), (Object)this.config.group());
            Iterator groups = ((User)auth).memberOf();
            while (groups.hasNext()) {
                if (!((Group)groups.next()).getID().equals(this.config.group())) continue;
                allowed = true;
                break;
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected exception checking group membership", (Throwable)e);
            return false;
        }
        return allowed;
    }

    public void destroy() {
    }
}

