/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=members"})
public class MembersOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(MembersOperation.class);
    public static final String PN_MEMBERS = ":members";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList<Modification> changes = new ArrayList<Modification>();
        try {
            ArrayList auths = new ArrayList();
            Optional.ofNullable(request.getParameterValues(PN_MEMBERS)).ifPresent(p -> auths.addAll(Arrays.asList(p)));
            AuthorizableWrapper groupWrapper = (AuthorizableWrapper)Optional.ofNullable(request.getResource().adaptTo(AuthorizableWrapper.class)).orElseThrow(() -> new RepositoryException("Failed to get group"));
            if (!groupWrapper.getAuthorizable().isGroup()) {
                throw new RepositoryException("Provided authorizable is not a group");
            }
            Group group = (Group)groupWrapper.getAuthorizable();
            response.setPath(group.getPath());
            changes.add(Modification.onModified((String)group.getPath()));
            group.getDeclaredMembers().forEachRemaining(member -> {
                try {
                    if (!auths.contains(member.getPath())) {
                        log.debug("Removing member {} from {}", member, (Object)group);
                        group.removeMember(member);
                        changes.add(Modification.onModified((String)member.getPath()));
                    } else {
                        auths.remove(member.getPath());
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to remove members", (Throwable)e);
                }
            });
            for (String path : auths) {
                Resource resource = request.getResourceResolver().getResource(path);
                if (resource == null) {
                    throw new RepositoryException("Failed to resolve authorizable at " + path);
                }
                Authorizable authorizable = Optional.ofNullable(resource.adaptTo(AuthorizableWrapper.class)).map(AuthorizableWrapper::getAuthorizable).orElseThrow(() -> new RepositoryException("Failed to get authorizable from: " + resource));
                group.addMember(authorizable);
                changes.add(Modification.onModified((String)authorizable.getPath()));
                log.debug("Adding member {} to {}", (Object)authorizable, (Object)group);
            }
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.onModified(group.getPath());
        }
        catch (Exception e) {
            log.warn("Failed to update members", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

