/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.File;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightFactory;
import org.apache.sling.cms.insights.InsightsModel;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={InsightsModel.class})
public class InsightsModelImpl
implements InsightsModel {
    private static final Logger log = LoggerFactory.getLogger(InsightsModelImpl.class);
    @OSGiService
    private InsightFactory insightsFactory;
    private List<Insight> insights;
    private Resource resource;

    public InsightsModelImpl(Resource resource) {
        this.resource = resource;
    }

    @PostConstruct
    public void init() {
        if ("sling:File".equals(this.resource.getResourceType())) {
            log.debug("Gathering file insights for resource {}", (Object)this.resource);
            this.insights = this.insightsFactory.getInsights((File)this.resource.adaptTo(File.class));
        } else if ("sling:Page".equals(this.resource.getResourceType())) {
            log.debug("Gathering page insights for resource {}", (Object)this.resource);
            this.insights = this.insightsFactory.getInsights((Page)this.resource.adaptTo(Page.class));
        } else {
            log.debug("Insights not available for resource {}", (Object)this.resource);
            this.insights = Collections.emptyList();
        }
    }

    public List<Insight> getInsights() {
        return this.insights;
    }
}

