/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Collections;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.cms.ComponentConfiguration;
import org.apache.sling.cms.ComponentPolicyManager;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={ComponentConfiguration.class})
public class ComponentConfigurationImpl
implements ComponentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentConfigurationImpl.class);
    private Optional<Resource> configRsrc;

    public ComponentConfigurationImpl(Resource resource) {
        this.configRsrc = Optional.ofNullable(resource.adaptTo(ComponentPolicyManager.class)).map(ComponentPolicyManager::getComponentPolicy).map(p -> (Resource)p.getComponentConfigs().get(resource.getResourceType()));
        log.debug("Loaded configuration resource: {}", this.configRsrc);
    }

    public ValueMap getProperties() {
        return this.configRsrc.map(Resource::getValueMap).orElse((ValueMap)new ValueMapDecorator(Collections.emptyMap()));
    }

    public Resource getResource() {
        return this.configRsrc.orElse(null);
    }
}

