/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.cms.core.internal.CommonUtils;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class, ResourceResolver.class}, adapters={AuthorizableWrapper.class})
public class AuthorizableWrapperImpl
implements AuthorizableWrapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableWrapperImpl.class);
    private final Authorizable authorizable;

    public AuthorizableWrapperImpl(ResourceResolver resolver) throws RepositoryException {
        this.authorizable = CommonUtils.getUserManager(resolver).getAuthorizable(resolver.getUserID());
    }

    public AuthorizableWrapperImpl(Resource resource) throws RepositoryException {
        this.authorizable = CommonUtils.getUserManager(resource.getResourceResolver()).getAuthorizableByPath(resource.getPath());
        if (this.authorizable == null) {
            throw new RepositoryException("Failed to get authorizable from " + resource);
        }
    }

    public Authorizable getAuthorizable() {
        return this.authorizable;
    }

    public Iterator<Authorizable> getDeclaredMembers() {
        try {
            if (this.authorizable.isGroup()) {
                return ((Group)this.authorizable).getDeclaredMembers();
            }
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        catch (RepositoryException e) {
            log.error("Failed to get membership of authorizable: {}", (Object)this.authorizable, (Object)e);
            return Collections.emptyIterator();
        }
    }

    public Iterator<Group> getDeclaredMembership() {
        try {
            return this.authorizable.declaredMemberOf();
        }
        catch (RepositoryException e) {
            log.error("Failed to get membership of authorizable: {}", (Object)this.authorizable, (Object)e);
            return Collections.emptyIterator();
        }
    }

    public Iterator<String> getGroupNames() {
        Iterable iterable = () -> this.getMembership();
        return StreamSupport.stream(iterable.spliterator(), false).map(g -> {
            try {
                return g.getPrincipal().getName();
            }
            catch (RepositoryException e) {
                log.error("Failed to get name from group: {}", g, (Object)e);
                return null;
            }
        }).iterator();
    }

    public String getId() {
        try {
            return this.authorizable.getID();
        }
        catch (RepositoryException e) {
            log.error("Failed to get ID from authorizable: {}", (Throwable)e);
            return null;
        }
    }

    public Iterator<Authorizable> getMembers() {
        try {
            if (this.authorizable.isGroup()) {
                return ((Group)this.authorizable).getMembers();
            }
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        catch (RepositoryException e) {
            log.error("Failed to get membership of authorizable: {}", (Object)this.authorizable, (Object)e);
            return Collections.emptyIterator();
        }
    }

    public Iterator<Group> getMembership() {
        try {
            return this.authorizable.memberOf();
        }
        catch (RepositoryException e) {
            log.error("Failed to get membership of authorizable: {}", (Object)this.authorizable, (Object)e);
            return Collections.emptyIterator();
        }
    }

    public boolean isAdministrator() {
        try {
            return !this.authorizable.isGroup() && ("admin".equals(this.authorizable.getID()) || this.isMember("administrators"));
        }
        catch (RepositoryException e) {
            log.error("Failed to check if authorizable is an administrator", (Throwable)e);
            return false;
        }
    }

    public boolean isMember(String groupName) {
        Iterable iterable = () -> this.getMembership();
        return StreamSupport.stream(iterable.spliterator(), false).anyMatch(g -> {
            try {
                return groupName.equals(g.getID());
            }
            catch (RepositoryException e) {
                log.error("Failed to get ID from authorizable: {}", g, (Object)e);
                return false;
            }
        });
    }
}

