/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.listeners;

import java.util.Collections;
import java.util.List;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.cms.File;
import org.apache.sling.cms.FileMetadataExtractor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileMetadataExtractorListener.class, ResourceChangeListener.class, ExternalResourceChangeListener.class}, property={"resource.change.types=ADDED", "resource.paths=/content", "resource.paths=/static"}, immediate=true)
public class FileMetadataExtractorListener
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorListener.class);
    @Reference
    private FileMetadataExtractor extractor;
    @Reference
    private ResourceResolverFactory factory;

    private void handleChange(Resource changed) {
        if ("sling:File".equals(changed.getResourceType())) {
            log.debug("Extracting metadata from changed resource: {}", (Object)changed);
            try {
                this.extractor.updateMetadata((File)changed.adaptTo(File.class), true);
            }
            catch (Exception e) {
                log.warn("Failed to extract metadata from change: {}", (Object)changed, (Object)e);
            }
        } else {
            log.trace("Not extracting metadata from changed resource: {}", (Object)changed);
        }
    }

    public void onChange(List<ResourceChange> changes) {
        try (ResourceResolver serviceResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-metadata"));){
            for (ResourceChange rc : changes) {
                Resource changed = serviceResolver.getResource(rc.getPath());
                this.handleChange(changed);
            }
        }
        catch (LoginException e) {
            log.error("Exception getting service user", (Throwable)e);
        }
    }
}

