/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.servlets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.cms.core.internal.servlets.PathSuggestionServletConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/bin/cms/paths", "sling.servlet.methods=GET"})
@Designate(ocd=PathSuggestionServletConfig.class)
public class PathSuggestionServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -410942682163323725L;
    private static final Logger log = LoggerFactory.getLogger(PathSuggestionServlet.class);
    private static final Map<String, String[]> typeFilters = new HashMap<String, String[]>();

    @Activate
    public void activate(PathSuggestionServletConfig config) {
        typeFilters.clear();
        for (String filter : config.typeFilters()) {
            String[] parts = filter.split("\\=");
            String key = parts[0];
            String[] types = parts[1].split("\\,");
            typeFilters.put(key, types);
        }
        log.info("Loaded type filters {}", typeFilters);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = "/";
        }
        log.debug("Finding valid paths under {}", (Object)path);
        String type = request.getParameter("type");
        if (!typeFilters.containsKey(type)) {
            type = "all";
        }
        log.debug("Filtering by type: {}", (Object)type);
        JsonArrayBuilder arrBuilder = Json.createArrayBuilder();
        Resource parent = request.getResourceResolver().getResource(path);
        if (parent == null) {
            if (StringUtils.isEmpty((CharSequence)(path = StringUtils.left((String)path, (int)path.lastIndexOf(47))))) {
                path = "/";
            }
            log.debug("Using stemmed path {}", (Object)path);
            parent = request.getResourceResolver().getResource(path);
        }
        if (parent != null) {
            for (Resource child : parent.getChildren()) {
                if (!this.isIncluded(child, type)) continue;
                arrBuilder.add(child.getPath());
            }
        }
        response.setContentType("application/json");
        response.getWriter().write(arrBuilder.build().toString());
    }

    private boolean isIncluded(Resource child, String type) {
        try {
            Node node = (Node)child.adaptTo(Node.class);
            if (node != null) {
                for (String t : typeFilters.get(type)) {
                    if (!node.isNodeType(t)) continue;
                    return true;
                }
            } else {
                log.debug("Unable to adapt child resource {} to node", (Object)child.getPath());
            }
        }
        catch (RepositoryException e) {
            log.warn("Unexpected exception accessing JCR Node", (Throwable)e);
        }
        return false;
    }
}

