/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SlingPostProcessor.class}, property={"service.ranking=-1"})
public class TouchLastModifiedPostOperation
implements SlingPostProcessor {
    public static final String RP_UPDATE_REFERENCES = ":updateReferences";
    private static final Logger log = LoggerFactory.getLogger(TouchLastModifiedPostOperation.class);

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        List paths = changes.stream().filter(m -> m.getType() == ModificationType.CREATE || m.getType() == ModificationType.MODIFY || m.getType() == ModificationType.ORDER).map(Modification::getSource).collect(Collectors.toList());
        paths.addAll(changes.stream().filter(m -> m.getType() == ModificationType.COPY || m.getType() == ModificationType.MOVE).map(Modification::getDestination).collect(Collectors.toList()));
        log.debug("Found {} applicable paths", (Object)paths.size());
        HashSet parentPaths = new HashSet();
        List<Resource> resources = paths.stream().map(p -> request.getResourceResolver().getResource(p)).map(CMSUtils::findPublishableParent).filter(p -> {
            if (parentPaths.contains(p.getPath())) {
                return false;
            }
            parentPaths.add(p.getPath());
            return true;
        }).collect(Collectors.toList());
        log.debug("Filtered to {} publishable resources", (Object)resources.size());
        resources.forEach(r -> {
            Optional<ModifiableValueMap> op = Optional.ofNullable(r.getChild("jcr:content")).map(c -> (ModifiableValueMap)c.adaptTo(ModifiableValueMap.class));
            op.ifPresent(mvm -> {
                log.debug("Updating last modified date on parent of {}", (Object)request.getResource());
                mvm.put((Object)"jcr:lastModifiedBy", (Object)request.getResourceResolver().getUserID());
                mvm.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
            });
            if (!op.isPresent()) {
                log.warn("Unable to get modifiable value map for {}", (Object)request.getResource());
            }
        });
    }
}

