/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Collection;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.CurrentUser;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={ResourceResolver.class}, adapters={CurrentUser.class})
public class CurrentUserImpl
implements CurrentUser {
    private ResourceResolver resolver;
    private UserManager userManager;
    private Collection<String> groupNames;
    private static final Logger log = LoggerFactory.getLogger(CurrentUserImpl.class);

    public CurrentUserImpl(ResourceResolver resolver) {
        this.resolver = resolver;
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            JackrabbitSession js = (JackrabbitSession)session;
            if (js != null) {
                this.userManager = js.getUserManager();
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to get user manager", (Throwable)e);
        }
    }

    public String getId() {
        return this.resolver.getUserID();
    }

    public Collection<String> getGroups() {
        if (this.groupNames == null) {
            this.groupNames = new HashSet<String>();
            User user = null;
            try {
                user = (User)this.userManager.getAuthorizable(this.getId());
                user.memberOf().forEachRemaining(g -> {
                    try {
                        this.groupNames.add(g.getID());
                    }
                    catch (RepositoryException e) {
                        log.warn("Failed to get group name", (Throwable)e);
                    }
                });
            }
            catch (RepositoryException re) {
                log.warn("Failed to get user", (Throwable)re);
            }
        }
        return this.groupNames;
    }

    public boolean isMember(String groupName) {
        return "admin".equals(this.getId()) || this.getGroups().contains("administrators") || this.getGroups().contains(groupName);
    }
}

