/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.cms.CMSJobManager;
import org.apache.sling.cms.ConfigurableJobExecutor;
import org.apache.sling.cms.CurrentUser;
import org.apache.sling.cms.core.internal.models.InternalCMSJobManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={CMSJobManager.class})
public class CMSJobManagerImpl
implements CMSJobManager {
    private static final String PN_INITIATOR = "_initiator";
    private static final String PN_JOB_TITLE_KEY = "_titleKey";
    private static final String PN_USER_ID = "_userId";
    private static final String VALUE_SLING_CMS = "SlingCMS";
    @OSGiService
    private InternalCMSJobManager cmsJobManager;
    @OSGiService
    private JobManager jobManager;
    private SlingHttpServletRequest request;

    public CMSJobManagerImpl(SlingHttpServletRequest request) {
        CurrentUser currentUser = (CurrentUser)request.getResourceResolver().adaptTo(CurrentUser.class);
        if (currentUser == null || !currentUser.isMember("job-users")) {
            throw new SlingException("User " + request.getResourceResolver().getUserID() + " is not a member of job-users", null);
        }
        this.request = request;
    }

    public void deleteJob(String id) {
        this.jobManager.removeJobById(id);
    }

    public Collection<ConfigurableJobExecutor> getAvailableJobs() {
        return this.cmsJobManager.getJobs();
    }

    public Collection<Job> getJobs() {
        HashMap<String, String> search = new HashMap<String, String>();
        search.put(PN_USER_ID, this.request.getResourceResolver().getUserID());
        search.put(PN_INITIATOR, VALUE_SLING_CMS);
        return Stream.concat(this.jobManager.findJobs(JobManager.QueryType.ALL, null, 0L, new Map[]{search}).stream(), this.jobManager.findJobs(JobManager.QueryType.HISTORY, null, 0L, new Map[]{search}).stream()).collect(Collectors.toList());
    }

    private String getJobTitleKey(String jobTopic) {
        return this.cmsJobManager.getJobs().stream().filter(j -> jobTopic.equals(j.getTopic())).map(ConfigurableJobExecutor::getTitleKey).findFirst().orElse(null);
    }

    public Job getSuffixJob() {
        return this.jobManager.getJobById(Optional.ofNullable(this.request.getRequestPathInfo().getSuffix()).orElse(" ").substring(1));
    }

    public Job startJob() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.request.getRequestParameterMap().forEach((k, v) -> {
            if (v != null && ((RequestParameter[])v).length > 0) {
                if (((RequestParameter[])v).length > 1) {
                    properties.put((String)k, (String)Arrays.stream(v).map(RequestParameter::getString).collect(Collectors.toList()).toArray(new String[((RequestParameter[])v).length]));
                } else {
                    properties.put((String)k, v[0].getString());
                }
            }
        });
        properties.remove("job.topics");
        String jobTopic = this.request.getParameter("job.topics");
        String titleKey = this.getJobTitleKey(jobTopic);
        if (titleKey != null) {
            properties.put(PN_JOB_TITLE_KEY, titleKey);
        }
        properties.put(PN_USER_ID, this.request.getResourceResolver().getUserID());
        properties.put(PN_INITIATOR, VALUE_SLING_CMS);
        return this.jobManager.addJob(jobTopic, properties);
    }
}

