/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.listeners;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.cms.File;
import org.apache.sling.cms.FileMetadataExtractor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileMetadataExtractorListener.class, ResourceChangeListener.class, ExternalResourceChangeListener.class}, property={"resource.change.types=ADDED", "resource.paths=/content", "resource.paths=/static"}, immediate=true)
public class FileMetadataExtractorListener
implements ResourceChangeListener,
ExternalResourceChangeListener {
    @Reference
    private FileMetadataExtractor extractor;
    @Reference
    private ResourceResolverFactory factory;
    private static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(List<ResourceChange> changes) {
        HashMap<String, String> serviceParams = new HashMap<String, String>();
        serviceParams.put("sling.service.subservice", "sling-cms-metadata");
        try (ResourceResolver serviceResolver = null;){
            serviceResolver = this.factory.getServiceResourceResolver(serviceParams);
            for (ResourceChange rc : changes) {
                this.handleChange(serviceResolver, rc);
            }
        }
    }

    private void handleChange(ResourceResolver serviceResolver, ResourceChange rc) {
        File changed = Optional.ofNullable(serviceResolver.getResource(rc.getPath())).map(r -> (File)r.adaptTo(File.class)).orElse(null);
        try {
            if (changed != null) {
                this.extractor.updateMetadata(changed);
            } else {
                log.warn("Failed to get File from: {}", (Object)rc.getPath());
            }
        }
        catch (IOException t) {
            log.warn("Failed to extract metadata due to exception", (Throwable)t);
        }
    }
}

