/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.cms.File;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.insights.impl.FileInsightRequestImpl;
import org.apache.sling.cms.core.insights.impl.PageInsightRequestImpl;
import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightFactory;
import org.apache.sling.cms.insights.InsightProvider;
import org.apache.sling.cms.insights.InsightRequest;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(immediate=true, service={InsightFactory.class})
public class InsightFactoryImpl
implements InsightFactory {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    private List<InsightProvider> providers;
    @Reference
    private SlingRequestProcessor requestProcessor;

    public List<Insight> getInsights(File file) {
        return this.getInsights((InsightRequest)new FileInsightRequestImpl(file));
    }

    private List<Insight> getInsights(InsightRequest request) {
        List<Insight> insights = this.providers.stream().filter(ip -> ip.isEnabled(request)).map(ip -> ip.evaluateRequest(request)).collect(Collectors.toList());
        Collections.sort(insights, (o1, o2) -> o1.getProvider().getTitle().compareTo(o2.getProvider().getTitle()));
        return insights;
    }

    public List<Insight> getInsights(Page page) {
        return this.getInsights((InsightRequest)new PageInsightRequestImpl(page, this.requestProcessor));
    }

    public List<InsightProvider> getProviders() {
        return this.providers;
    }
}

