/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.readability.impl;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.cms.core.readability.impl.ReadabilityConfig;
import org.apache.sling.cms.readability.ReadabilityService;
import org.apache.sling.cms.readability.Sentence;
import org.apache.sling.cms.readability.Text;
import org.apache.sling.cms.readability.Word;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={ReadabilityService.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=ReadabilityConfig.class, factory=true)
public class ReadabilityServiceImpl
implements ReadabilityService {
    private int complexityMin;
    private Pattern extraVowelExpression;
    private Pattern isWordExpression;
    private Locale locale;
    private Pattern vowelExpression;
    private List<String> wordstems;

    @Activate
    public void activate(ReadabilityConfig config) {
        this.complexityMin = config.complexityMin();
        this.extraVowelExpression = Pattern.compile(config.extraVowelExpression());
        this.isWordExpression = Pattern.compile(config.isWordExpression());
        this.locale = Locale.forLanguageTag(config.locale());
        this.vowelExpression = Pattern.compile(config.vowelExpression());
        this.wordstems = Arrays.asList(config.wordstems());
    }

    public double calculateARI(String text) {
        return this.calculateARI(this.extractSentences(text));
    }

    public double calculateARI(Text text) {
        int wordCount = text.getWordCount();
        return 4.71 * (double)text.getCharacterCount() / (double)wordCount + 0.5 * (double)wordCount / (double)text.getSentences().size() - 21.43;
    }

    public double calculateAverageGradeLevel(String text) {
        return this.calculateAverageGradeLevel(this.extractSentences(text));
    }

    public double calculateAverageGradeLevel(Text text) {
        double[] results = new double[]{this.calculateARI(text), this.calculateColemanLiauIndex(text), this.calculateFleschKincaidGradeLevel(text), this.calculateGunningFog(text), this.calculateSMOG(text)};
        double sum = 0.0;
        for (double result : results) {
            sum += result;
        }
        return sum / (double)results.length;
    }

    public double calculateColemanLiauIndex(String text) {
        return this.calculateColemanLiauIndex(this.extractSentences(text));
    }

    public double calculateColemanLiauIndex(Text text) {
        int wordCount = text.getWordCount();
        return 5.89 * (double)text.getCharacterCount() / (double)wordCount - (double)(30 * text.getSentences().size()) / (double)wordCount - 15.8;
    }

    public double calculateFleschKincaidGradeLevel(String text) {
        return this.calculateFleschKincaidGradeLevel(this.extractSentences(text));
    }

    public double calculateFleschKincaidGradeLevel(Text text) {
        int wordCount = text.getWordCount();
        return 0.39 * ((double)wordCount / (double)text.getSentences().size()) + 11.8 * ((double)text.getSyllableCount() / (double)wordCount) - 15.59;
    }

    public double calculateFleschReadingEase(String text) {
        return this.calculateFleschReadingEase(this.extractSentences(text));
    }

    public double calculateFleschReadingEase(Text text) {
        int wordCount = text.getWordCount();
        return 206.835 - 1.015 * (double)wordCount / (double)text.getSentences().size() - 84.6 * (double)text.getSyllableCount() / (double)wordCount;
    }

    public double calculateGunningFog(String text) {
        return this.calculateGunningFog(this.extractSentences(text));
    }

    public double calculateGunningFog(Text text) {
        int wordCount = text.getWordCount();
        return 0.4 * ((double)wordCount / (double)text.getSentences().size() + 100.0 * ((double)text.getComplexWordCount() / (double)wordCount));
    }

    public double calculateSMOG(String text) {
        return this.calculateSMOG(this.extractSentences(text));
    }

    public double calculateSMOG(Text text) {
        return 1.043 * Math.sqrt((double)text.getComplexWordCount() * (30.0 / (double)text.getSentences().size())) + 3.1291;
    }

    private int countSylables(String word) {
        int result = 0;
        for (int index = 0; index < word.length(); ++index) {
            if (!this.isVowel(word.charAt(index))) continue;
            ++result;
        }
        if (this.extraVowelExpression.matcher(word).matches()) {
            ++result;
        }
        return result;
    }

    private String deduplicateVowels(String word) {
        for (int index = 0; index < word.length() - 1; ++index) {
            if (!this.isVowel(word.charAt(index)) || !this.isVowel(word.charAt(index + 1)) || index + 2 >= word.length()) continue;
            word = word.substring(0, index + 1) + word.substring(index + 2);
        }
        return word;
    }

    public Text extractSentences(String input) {
        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.locale);
        breakIterator.setText(input);
        int start = breakIterator.first();
        ArrayList<String> sentenceStrs = new ArrayList<String>();
        int end = breakIterator.next();
        while (end != -1) {
            sentenceStrs.add(input.substring(start, end));
            start = end;
            end = breakIterator.next();
        }
        return new Text(input, sentenceStrs.stream().map(s -> new Sentence(s, this.extractWords((String)s))).collect(Collectors.toList()));
    }

    private List<Word> extractWords(String sentence) {
        ArrayList<Word> words = new ArrayList<Word>();
        BreakIterator wordIterator = BreakIterator.getWordInstance(this.locale);
        wordIterator.setText(sentence);
        int start = wordIterator.first();
        int end = wordIterator.next();
        while (end != -1) {
            String original = sentence.substring(start, end);
            String wordStr = original.toLowerCase(this.locale);
            wordStr = this.deduplicateVowels(wordStr);
            wordStr = this.stripWordStem(wordStr);
            wordStr = wordStr.trim();
            int sylables = this.countSylables(wordStr);
            if (!wordStr.isEmpty() && (sylables != 0 || this.isWordExpression.matcher(wordStr).matches())) {
                if (sylables == 0) {
                    sylables = 1;
                }
                Word word = new Word(original, wordStr, sylables, sylables >= this.complexityMin);
                words.add(word);
            }
            start = end;
            end = wordIterator.next();
        }
        return words;
    }

    private boolean isVowel(char ch) {
        return this.vowelExpression.matcher(String.valueOf(ch)).matches();
    }

    private String stripWordStem(String wordStr) {
        for (String stem : this.wordstems) {
            if (!wordStr.endsWith(stem)) continue;
            return wordStr.substring(0, wordStr.length() - stem.length());
        }
        return wordStr;
    }
}

