/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class ErrorHandler {
    public static final String DEFAULT_ERROR_PAGE = "default";
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);
    public static final String SERVICE_USER_NAME = "sling-cms-error";
    public static final String SITE_ERRORS_SUBPATH = "errors/";
    public static final String SLING_CMS_ERROR_PATH = "/content/sling-cms/errorhandling/";
    @RequestAttribute
    @Named(value="javax.servlet.error.status_code")
    @Optional
    @Default(intValues={500})
    private Integer errorCode;
    @OSGiService
    private ResourceResolverFactory factory;
    private Resource handler;
    @SlingObject
    private SlingHttpServletResponse slingResponse;
    private SlingHttpServletRequest slingRequest;

    public ErrorHandler(SlingHttpServletRequest slingRequest) {
        this.slingRequest = slingRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateErrorCode(ResourceResolver resolver) {
        if (this.errorCode == 404) {
            log.debug("Validating the resource does not exist for all users");
            try (ResourceResolver adminResolver = null;){
                adminResolver = this.factory.getServiceResourceResolver((Map)new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("sling.service.subservice", ErrorHandler.SERVICE_USER_NAME);
                    }
                });
                Resource pResource = adminResolver.resolve((HttpServletRequest)this.slingRequest, this.slingRequest.getResource().getPath());
                this.errorCode = !CMSUtils.isPublished((Resource)pResource) || pResource.isResourceType("sling:nonexisting") ? Integer.valueOf(404) : ("anonymous".equals(resolver.getUserID()) ? Integer.valueOf(401) : Integer.valueOf(403));
            }
        }
    }

    private void doInclude() {
        Resource handlerContent = this.handler.getChild("jcr:content");
        if (handlerContent != null) {
            log.debug("Including handler {}", (Object)handlerContent);
            RequestDispatcherOptions rdo = new RequestDispatcherOptions();
            rdo.setReplaceSelectors("");
            rdo.setReplaceSuffix("");
            rdo.setForceResourceType(handlerContent.getResourceType());
            RequestDispatcher dispatcher = this.slingRequest.getRequestDispatcher(handlerContent, rdo);
            if (dispatcher != null) {
                try {
                    dispatcher.include((ServletRequest)new GetRequest(this.slingRequest), (ServletResponse)this.slingResponse);
                }
                catch (Exception e) {
                    log.debug("Exception swallowed while including error page", (Throwable)e);
                }
            } else {
                log.warn("Failed to get request dispatcher for handler {}", (Object)this.handler.getPath());
            }
        } else {
            log.warn("Error hander {} content is null", (Object)this.handler);
        }
    }

    @PostConstruct
    public void init() {
        Resource resource = this.slingRequest.getResource();
        ResourceResolver resolver = this.slingRequest.getResourceResolver();
        log.debug("Calculating error handling scripts for resource {} and error code {}", (Object)resource, (Object)this.errorCode);
        if (this.slingRequest.getAttribute("javax.servlet.error.exception") != null) {
            log.warn("Handing exception of type {}", (Object)this.errorCode, (Object)((Throwable)this.slingRequest.getAttribute("javax.servlet.error.exception")));
        }
        this.calculateErrorCode(resolver);
        try {
            SiteManager siteMgr = (SiteManager)resource.adaptTo(SiteManager.class);
            if (siteMgr != null && siteMgr.getSite() != null) {
                Site site = siteMgr.getSite();
                log.debug("Checking for error pages in the site {}", (Object)site.getPath());
                this.handler = site.getResource().getChild(SITE_ERRORS_SUBPATH + this.errorCode.toString());
                if (this.handler == null) {
                    this.handler = site.getResource().getChild("errors/default");
                }
                if (this.handler != null) {
                    log.debug("Using error handler {}", (Object)this.handler);
                } else {
                    log.debug("No error page defined for site {}", (Object)site.getPath());
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to retrieve current site, using default error handling");
        }
        if (this.handler == null) {
            log.debug("Using Sling CMS default error pages");
            this.handler = resolver.getResource(SLING_CMS_ERROR_PATH + this.errorCode.toString());
            if (this.handler == null) {
                this.handler = resolver.getResource("/content/sling-cms/errorhandling/default");
            }
            log.debug("Using Sling CMS error handler {}", (Object)this.handler);
        }
        log.debug("Sending error {}", (Object)this.errorCode);
        this.slingResponse.reset();
        this.slingResponse.setContentType("text/html");
        this.slingResponse.setStatus(this.errorCode.intValue());
        this.doInclude();
        log.debug("Error handler initialized successfully!");
    }

    private static class HTMLRequestPathInfo
    implements RequestPathInfo {
        private RequestPathInfo info;

        public HTMLRequestPathInfo(RequestPathInfo info) {
            this.info = info;
        }

        public String getResourcePath() {
            return this.info.getResourcePath();
        }

        public String getExtension() {
            return "html";
        }

        public String getSelectorString() {
            return "";
        }

        public String[] getSelectors() {
            return new String[0];
        }

        public String getSuffix() {
            return "";
        }

        public Resource getSuffixResource() {
            return null;
        }
    }

    private static class GetRequest
    extends SlingHttpServletRequestWrapper {
        public GetRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }

        public RequestPathInfo getRequestPathInfo() {
            return new HTMLRequestPathInfo(super.getRequestPathInfo());
        }
    }
}

