/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.rewriter;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.cms.core.internal.rewriter.ReferenceMappingTransformerConfig;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceMappingTransformer
implements Transformer {
    private static final Logger log = LoggerFactory.getLogger(ReferenceMappingTransformer.class);
    private ContentHandler contentHandler;
    private SlingHttpServletRequest slingRequest;
    private ReferenceMappingTransformerConfig config;
    private boolean enabled = false;
    private ConfigurationResourceResolver resolver;
    private String[] attributes;

    public ReferenceMappingTransformer(ReferenceMappingTransformerConfig config, ConfigurationResourceResolver resolver) {
        this.config = config;
        this.resolver = resolver;
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        atts = this.mapReferences(atts);
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    private Attributes mapReferences(Attributes atts) {
        if (this.enabled) {
            AttributesImpl newAtts = new AttributesImpl();
            for (int i = 0; i < atts.getLength(); ++i) {
                String value = null;
                if (ArrayUtils.contains((Object[])this.attributes, (Object)atts.getLocalName(i).toLowerCase()) && atts.getValue(i).startsWith("/")) {
                    log.trace("Updating attribute {}", (Object)atts.getLocalName(i));
                    value = this.slingRequest.getResourceResolver().map((HttpServletRequest)this.slingRequest, atts.getValue(i));
                    log.trace("Mapped value {}", (Object)value);
                } else {
                    log.trace("Skipping attribute {}", (Object)atts.getLocalName(i));
                    value = atts.getValue(i);
                }
                newAtts.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), value);
            }
            return newAtts;
        }
        return atts;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void dispose() {
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration cfg) throws IOException {
        log.trace("init");
        this.slingRequest = context.getRequest();
        if (this.config != null && this.config.enabledPaths() != null && !"true".equals(this.slingRequest.getAttribute("cmsEditEnabled"))) {
            Resource configResource;
            for (String enabledPath : this.config.enabledPaths()) {
                if (!this.slingRequest.getResource().getPath().startsWith(enabledPath)) continue;
                this.enabled = true;
                break;
            }
            if ((configResource = this.resolver.getResource(this.slingRequest.getResource(), "site", "rewrite")) != null) {
                this.attributes = (String[])configResource.getValueMap().get("attributes", String[].class);
            } else {
                log.warn("Unable to find configuration for {}", (Object)this.slingRequest.getResource());
            }
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }
}

