/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.ArrayList;
import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.PageTemplate;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class}, adapters={Page.class})
public class PageImpl
implements Page {
    @Inject
    @Optional
    @Named(value="jcr:content")
    private Resource contentResource;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:created")
    private Calendar created;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:createdBy")
    private String createdBy;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModified")
    private Calendar lastModified;
    @Inject
    @Optional
    @Named(value="jcr:content/jcr:lastModifiedBy")
    private String lastModifiedBy;
    @Inject
    @Named(value="jcr:content/published")
    @Default(booleanValues={false})
    private boolean published;
    protected Resource resource;
    @Inject
    @Optional
    @Named(value="jcr:content/sling:taxonomy")
    private String[] taxonomy;
    @Inject
    @Optional
    @Named(value="jcr:content/sling:template")
    private String template;
    @Inject
    @Named(value="jcr:content/jcr:title")
    @Optional
    private String title;
    @Inject
    @Named(value="jcr:primaryType")
    private String type;

    public static final Page getContainingPage(Resource resource) {
        Resource pageRsrc = CMSUtils.findParentResourceofType((Resource)resource, (String)"sling:Page");
        Page page = null;
        if (pageRsrc != null) {
            page = (Page)pageRsrc.adaptTo(Page.class);
        }
        return page;
    }

    public PageImpl(Resource resource) {
        this.resource = resource;
    }

    public Resource getContentResource() {
        return this.contentResource;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String[] getKeywords() {
        ArrayList<Object> keywords = new ArrayList<Object>();
        if (this.taxonomy != null) {
            for (String item : this.taxonomy) {
                Resource rsrc = this.resource.getResourceResolver().getResource(item);
                if (rsrc == null) continue;
                keywords.add(rsrc.getValueMap().get("jcr:title", String.class));
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    public Calendar getLastModified() {
        return this.lastModified != null ? this.lastModified : this.created;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy != null ? this.lastModifiedBy : this.createdBy;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Resource getParent() {
        return this.resource.getParent();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ValueMap getProperties() {
        return this.getContentResource().getValueMap();
    }

    public String getPublishedPath() {
        Site site = this.getSite();
        if (site != null) {
            return this.resource.getPath().replace(site.getPath(), "") + ".html";
        }
        return this.resource.getPath() + ".html";
    }

    public String getPublishedUrl() {
        Site site = this.getSite();
        if (site != null) {
            return site.getUrl() + this.getPublishedPath();
        }
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Site getSite() {
        SiteManager siteMgr = (SiteManager)this.resource.adaptTo(SiteManager.class);
        Site site = null;
        if (siteMgr != null) {
            site = siteMgr.getSite();
        }
        return site;
    }

    public PageTemplate getTemplate() {
        Resource templateResource = this.resource.getResourceResolver().getResource(this.template);
        if (templateResource != null) {
            return (PageTemplate)templateResource.adaptTo(PageTemplate.class);
        }
        return null;
    }

    public String getTemplatePath() {
        return this.template;
    }

    public String getTitle() {
        if (StringUtils.isNotEmpty((String)this.title)) {
            return this.title;
        }
        return this.resource.getName();
    }

    public boolean isPublished() {
        return this.published;
    }
}

