/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.insights.impl.FakeRequest;
import org.apache.sling.cms.core.insights.impl.FakeResponse;
import org.apache.sling.cms.insights.PageInsightRequest;
import org.apache.sling.engine.SlingRequestProcessor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageInsightRequestImpl
implements PageInsightRequest {
    private static final Logger log = LoggerFactory.getLogger(PageInsightRequestImpl.class);
    private Map<String, String> markupCache = new HashMap<String, String>();
    private final Page page;
    private final SlingRequestProcessor requestProcessor;
    private final ResourceResolver resourceResolver;

    public PageInsightRequestImpl(Page page, SlingRequestProcessor requestProcessor) {
        this.page = page;
        this.requestProcessor = requestProcessor;
        this.resourceResolver = page.getResource().getResourceResolver();
    }

    private String getContents(String url) {
        log.trace("getLocalPageHTML");
        if (!this.markupCache.containsKey(url)) {
            String requestPath = this.page.getPath() + ".html";
            log.debug("Loading local page HTML from {}", (Object)requestPath);
            FakeRequest req = new FakeRequest("GET", requestPath);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                FakeResponse resp = new FakeResponse(out);
                this.requestProcessor.processRequest((HttpServletRequest)req, (HttpServletResponse)resp, this.resourceResolver);
            }
            catch (IOException | NoSuchAlgorithmException | ServletException e) {
                log.warn("Exception retrieving page contents for {}", (Object)url, (Object)e);
            }
            this.markupCache.put(url, out.toString());
        }
        return this.markupCache.get(url);
    }

    public Page getPage() {
        return this.page;
    }

    public Element getPageBodyElement() throws IOException {
        return Jsoup.parseBodyFragment((String)this.getPageBodyHtml()).body();
    }

    public String getPageBodyHtml() throws IOException {
        return this.getContents(this.page.getPath() + "/jcr:content/container.html");
    }

    public Document getPageDocument() throws IOException {
        return Jsoup.parse((String)this.getPageHtml());
    }

    public String getPageHtml() throws IOException {
        return this.getContents(this.page.getPath() + ".html");
    }

    public Resource getResource() {
        return this.page.getResource();
    }

    public String toString() {
        return "PageInsightRequestImpl [markupCache=" + this.markupCache + ", page=" + this.page + ", requestProcessor=" + this.requestProcessor + ", resourceResolver=" + this.resourceResolver + "]";
    }
}

