/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.cms.File;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.insights.impl.FileInsightRequestImpl;
import org.apache.sling.cms.core.insights.impl.PageInsightRequestImpl;
import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightFactory;
import org.apache.sling.cms.insights.InsightProvider;
import org.apache.sling.cms.insights.InsightRequest;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={InsightFactory.class, ServiceListener.class})
public class InsightFactoryImpl
implements InsightFactory,
ServiceListener {
    private static final Logger log = LoggerFactory.getLogger(InsightFactoryImpl.class);
    private static final Map<String, InsightProvider> insightProviders = new HashMap<String, InsightProvider>();
    @Reference
    private SlingRequestProcessor requestProcessor;

    @Activate
    public void activate(ComponentContext context) throws InvalidSyntaxException {
        log.info("activate");
        insightProviders.clear();
        String filter = "(objectClass=" + InsightProvider.class.getName() + ")";
        context.getBundleContext().addServiceListener((ServiceListener)this, filter);
        ServiceReference[] serviceReferences = context.getBundleContext().getServiceReferences(InsightProvider.class.getName(), null);
        if (serviceReferences != null) {
            Stream.of(serviceReferences).map(sr -> (InsightProvider)context.getBundleContext().getService(sr)).forEach(provider -> insightProviders.put(provider.getId(), (InsightProvider)provider));
        }
        log.info("Check Service Listener registered successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        InsightProvider provider = (InsightProvider)event.getServiceReference().getBundle().getBundleContext().getService(reference);
        InsightFactoryImpl insightFactoryImpl = this;
        synchronized (insightFactoryImpl) {
            log.info("Unregistering {}", (Object)provider.getId());
            insightProviders.remove(provider.getId());
            if (event.getType() == 2 || event.getType() == 1) {
                log.info("Registering {}", (Object)provider.getId());
                insightProviders.put(provider.getId(), provider);
            }
        }
    }

    public List<Insight> getInsights(File file) {
        return this.getInsights((InsightRequest)new FileInsightRequestImpl(file));
    }

    public List<Insight> getInsights(Page page) {
        return this.getInsights((InsightRequest)new PageInsightRequestImpl(page, this.requestProcessor));
    }

    public Collection<InsightProvider> getProviders() {
        return insightProviders.values();
    }

    private List<Insight> getInsights(InsightRequest request) {
        List<Insight> insights = insightProviders.values().stream().filter(ip -> ip.isEnabled(request)).map(ip -> ip.evaluateRequest(request)).collect(Collectors.toList());
        Collections.sort(insights, new Comparator<Insight>(){

            @Override
            public int compare(Insight o1, Insight o2) {
                return o1.getProvider().getTitle().compareTo(o2.getProvider().getTitle());
            }
        });
        return insights;
    }
}

