/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.readability.impl;

import java.util.Collection;
import java.util.Locale;
import org.apache.sling.cms.readability.ReadabilityService;
import org.apache.sling.cms.readability.ReadabilityServiceFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReadabilityServiceFactory.class})
public class ReadabilityServiceFactoryImpl
implements ReadabilityServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ReadabilityServiceFactoryImpl.class);
    private ComponentContext context;

    @Activate
    public void activate(ComponentContext context) {
        this.context = context;
    }

    public ReadabilityService getReadabilityService(Locale locale) {
        try {
            log.debug("Locating readability service for {}", (Object)locale);
            Collection references = this.context.getBundleContext().getServiceReferences(ReadabilityService.class, "(locale=" + locale.toString() + ")");
            if (references == null || references.isEmpty()) {
                log.debug("Trying language fallback {}", (Object)locale.getLanguage());
                references = this.context.getBundleContext().getServiceReferences(ReadabilityService.class, "(locale=" + locale.getLanguage() + ")");
            }
            if (references != null && !references.isEmpty()) {
                for (ServiceReference ref : references) {
                    ReadabilityService service = (ReadabilityService)this.context.getBundleContext().getService(ref);
                    if (service == null) continue;
                    log.debug("Found readability service for {}", (Object)locale);
                    return service;
                }
            } else {
                log.debug("No readibility services found for {}", (Object)locale);
            }
        }
        catch (InvalidSyntaxException e) {
            log.error("Exception creating expression to find service", (Throwable)e);
        }
        return null;
    }
}

