/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class})
public class VersionInfo {
    private Resource resource;

    public VersionInfo(Resource resource) {
        this.resource = resource;
    }

    public List<Version> getVersions() throws RepositoryException {
        ArrayList<Version> versions = new ArrayList<Version>();
        Node node = (Node)this.resource.adaptTo(Node.class);
        if (node != null && node.isNodeType("mix:versionable")) {
            VersionHistory history = node.getVersionHistory();
            VersionIterator it = history.getAllVersions();
            while (it.hasNext()) {
                Version v = it.nextVersion();
                versions.add(v);
            }
        }
        return versions;
    }
}

