/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl.providers;

import java.text.DecimalFormat;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.apache.sling.cms.core.insights.impl.BaseInsightProvider;
import org.apache.sling.cms.core.internal.models.ReadabilitySiteConfig;
import org.apache.sling.cms.i18n.I18NDictionary;
import org.apache.sling.cms.i18n.I18NProvider;
import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightProvider;
import org.apache.sling.cms.insights.InsightRequest;
import org.apache.sling.cms.insights.Message;
import org.apache.sling.cms.insights.PageInsightRequest;
import org.apache.sling.cms.readability.ReadabilityService;
import org.apache.sling.cms.readability.ReadabilityServiceFactory;
import org.apache.sling.cms.readability.Text;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InsightProvider.class})
public class ReadabilityInsightProvider
extends BaseInsightProvider {
    public static final String I18N_KEY_READABILITY_DETAIL = "slingcms.readability.detail";
    public static final String I18N_KEY_READABILITY_RESULT_DANGER = "slingcms.readability.danger";
    public static final String I18N_KEY_READABILITY_RESULT_SUCCESS = "slingcms.readability.success";
    public static final String I18N_KEY_READABILITY_RESULT_WARN = "slingcms.readability.warn";
    public static final String I18N_KEY_READABILITY_STATS = "slingcms.readability.stats";
    private static final Logger log = LoggerFactory.getLogger(ReadabilityInsightProvider.class);
    public static final String READABILITY_CA_CONFIG = "readability";
    @Reference
    private ConfigurationResourceResolver caResolver;
    @Reference
    private ReadabilityServiceFactory factory;
    @Reference
    private I18NProvider i18nProvider;

    private void addDetail(Insight insight, I18NDictionary dictionary, double score, String title) {
        insight.getScoreDetails().add(Message.defaultMsg((String)(title + ": " + new DecimalFormat("##0.00").format(score))));
    }

    @Override
    protected Insight doEvaluateRequest(InsightRequest request) throws Exception {
        Insight insight = new Insight((InsightProvider)this, request);
        PageInsightRequest pageRequest = (PageInsightRequest)request;
        String text = pageRequest.getPageBodyElement().text();
        Site site = null;
        SiteManager smgr = (SiteManager)request.getResource().adaptTo(SiteManager.class);
        if (smgr != null) {
            site = smgr.getSite();
        }
        Resource readabilityResource = this.caResolver.getResource(pageRequest.getPage().getResource(), "insights", READABILITY_CA_CONFIG);
        ReadabilitySiteConfig config = null;
        if (readabilityResource != null) {
            log.debug("Using readability configuration {}", (Object)readabilityResource);
            config = (ReadabilitySiteConfig)readabilityResource.adaptTo(ReadabilitySiteConfig.class);
        }
        I18NDictionary dictionary = this.i18nProvider.getDictionary(request.getResource().getResourceResolver());
        if (site != null && config != null) {
            ReadabilityService svc = this.factory.getReadabilityService(site.getLocale());
            double score = svc.calculateAverageGradeLevel(text);
            String scoreStr = new DecimalFormat("##0.00").format(score);
            insight.setScored(true);
            log.debug("Calculating readability of page {}", (Object)pageRequest.getPage());
            if (score > config.getMaxGradeLevel() || score < config.getMinGradeLevel()) {
                log.debug("Retrieved out of bounds readability {} based on range {}-{}", new Object[]{score, config.getMinGradeLevel(), config.getMaxGradeLevel()});
                StandardDeviation sd = new StandardDeviation(false);
                double stddev = sd.evaluate(new double[]{config.getMinGradeLevel(), config.getMaxGradeLevel()});
                double dev = 0.0;
                dev = score > config.getMaxGradeLevel() ? score - config.getMaxGradeLevel() : config.getMinGradeLevel() - score;
                double calcScore = 1.0 - dev / stddev * 0.5;
                if (calcScore > 0.0) {
                    insight.setScore(calcScore);
                } else {
                    insight.setScore(0.0);
                }
                insight.setPrimaryMessage(Message.warn((String)dictionary.get(I18N_KEY_READABILITY_RESULT_WARN, new Object[]{config.getMinGradeLevel(), config.getMaxGradeLevel(), scoreStr})));
            } else {
                log.debug("Retrieved in bounds readability {} based on range {}-{}", new Object[]{score, config.getMinGradeLevel(), config.getMaxGradeLevel()});
                insight.setScore(1.0);
                insight.setPrimaryMessage(Message.success((String)dictionary.get(I18N_KEY_READABILITY_RESULT_SUCCESS, new Object[]{config.getMinGradeLevel(), config.getMaxGradeLevel(), scoreStr})));
            }
            Text t = svc.extractSentences(text);
            insight.getScoreDetails().add(Message.defaultMsg((String)dictionary.get(I18N_KEY_READABILITY_STATS, new Object[]{t.getSentences().size(), t.getWordCount(), t.getComplexWordCount()})));
            this.addDetail(insight, dictionary, svc.calculateARI(t), "ARI");
            this.addDetail(insight, dictionary, svc.calculateColemanLiauIndex(t), "Coleman-Liau Index");
            this.addDetail(insight, dictionary, svc.calculateFleschKincaidGradeLevel(t), "Flesch-Kincaid Grade Level");
            this.addDetail(insight, dictionary, svc.calculateFleschReadingEase(t), "Flesch-Kincaid Reading Ease");
            this.addDetail(insight, dictionary, svc.calculateGunningFog(t), "Gunning Fog");
            this.addDetail(insight, dictionary, svc.calculateSMOG(t), "SMOG");
        } else {
            log.warn("Failed to get readability for resource {} site or config were null", (Object)pageRequest.getPage().getResource());
            insight.setScored(false);
            insight.setSucceeded(false);
            insight.setPrimaryMessage(Message.danger((String)dictionary.get(I18N_KEY_READABILITY_RESULT_DANGER, new Object[]{pageRequest.getPage().getPath()})));
        }
        return insight;
    }

    public String getId() {
        return READABILITY_CA_CONFIG;
    }

    public String getTitle() {
        return "Readability";
    }

    public boolean isEnabled(InsightRequest request) {
        Site site = null;
        SiteManager smgr = (SiteManager)request.getResource().adaptTo(SiteManager.class);
        if (smgr != null) {
            site = smgr.getSite();
        }
        if (request.getType() != InsightRequest.TYPE.PAGE) {
            log.debug("Insight is not of page type");
            return false;
        }
        if (site == null || site.getLocale() == null) {
            log.debug("Did not find site or locale");
            return false;
        }
        if (this.factory.getReadabilityService(site.getLocale()) == null) {
            log.debug("Unable to get readability service for locale {}", (Object)site.getLocale());
            return false;
        }
        return true;
    }
}

