/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.usergenerated.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.cms.usergenerated.UserGeneratedContentService;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=ugcapprove"})
public class ApproveUGCOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(ApproveUGCOperation.class);

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        log.trace("run");
        try {
            String path = request.getResource().getPath();
            response.setPath(path);
            log.debug("Approving UGC {}", (Object)path);
            ArrayList<Modification> changes = new ArrayList<Modification>();
            String targetPath = (String)request.getResource().getValueMap().get("targetpath", String.class);
            UserGeneratedContentService.APPROVE_ACTION action = UserGeneratedContentService.APPROVE_ACTION.valueOf((String)((String)request.getResource().getValueMap().get("approveaction", String.class)));
            if (action == UserGeneratedContentService.APPROVE_ACTION.MOVE) {
                ResourceUtil.getOrCreateResource((ResourceResolver)request.getResourceResolver(), (String)targetPath, (Map)new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("jcr:primaryType", "sling:Folder");
                    }
                }, (String)"sling:Folder", (boolean)false);
                for (Resource resource : request.getResource().getChildren()) {
                    log.debug("Moving {} to {}", (Object)resource.getPath(), (Object)targetPath);
                    changes.add(Modification.onMoved((String)resource.getPath(), (String)targetPath));
                    request.getResourceResolver().move(resource.getPath(), targetPath);
                }
                changes.add(Modification.onDeleted((String)request.getResource().getPath()));
                request.getResourceResolver().delete(request.getResource());
            } else {
                SlingPostProcessor[] mvm = (SlingPostProcessor[])request.getResource().adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"published", (Object)true);
                changes.add(Modification.onModified((String)request.getResource().getPath()));
            }
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
            request.getResourceResolver().commit();
        }
        catch (Exception e) {
            log.error("Exception during response processing.", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

